/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.loadable.LoadableCodec;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.ItemStackLoadable;
import slimeknights.mantle.data.loadable.common.NBTLoadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.TagPreference;
import slimeknights.mantle.util.typed.TypedMap;

public abstract class ItemOutput
implements Supplier<ItemStack> {
    public static Codec<ItemOutput> REQUIRED_STACK_CODEC = new LoadableCodec<ItemOutput>(Loadable.REQUIRED_STACK);
    public static final ItemOutput EMPTY = new OfStack(ItemStack.f_41583_);

    @Override
    public abstract ItemStack get();

    public final ItemStack copy() {
        return this.get().m_41777_();
    }

    public abstract int getCount();

    public boolean isEmpty() {
        return this.getCount() <= 0;
    }

    public abstract JsonElement serialize(boolean var1);

    public static ItemOutput fromStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return EMPTY;
        }
        return new OfStack(stack);
    }

    public static ItemOutput fromItem(ItemLike item, int count) {
        return new OfItem(item.m_5456_(), count);
    }

    public static ItemOutput fromItem(ItemLike item) {
        return ItemOutput.fromItem(item, 1);
    }

    public static ItemOutput fromTag(TagKey<Item> tag, int count, @Nullable CompoundTag nbt) {
        return new OfTagPreference(tag, count, nbt);
    }

    public static ItemOutput fromTag(TagKey<Item> tag, int count) {
        return ItemOutput.fromTag(tag, count, null);
    }

    public static ItemOutput fromTag(TagKey<Item> tag) {
        return ItemOutput.fromTag(tag, 1);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.get());
    }

    public static ItemOutput read(FriendlyByteBuf buffer) {
        return ItemOutput.fromStack(buffer.m_130267_());
    }

    private static class OfStack
    extends ItemOutput {
        private final ItemStack stack;

        @Override
        public ItemStack get() {
            return this.stack;
        }

        @Override
        public int getCount() {
            return this.stack.m_41613_();
        }

        @Override
        public JsonElement serialize(boolean writeCount) {
            if (writeCount) {
                return ItemStackLoadable.OPTIONAL_STACK_NBT.serialize(this.stack);
            }
            return ItemStackLoadable.OPTIONAL_ITEM_NBT.serialize(this.stack);
        }

        public OfStack(ItemStack stack) {
            this.stack = stack;
        }
    }

    private static class OfItem
    extends ItemOutput {
        private final Item item;
        private final int count;
        private ItemStack cachedStack;

        @Override
        public ItemStack get() {
            if (this.cachedStack == null) {
                this.cachedStack = new ItemStack((ItemLike)this.item, this.count);
            }
            return this.cachedStack;
        }

        @Override
        public JsonElement serialize(boolean writeCount) {
            JsonElement item = Loadables.ITEM.serialize(this.item);
            if (writeCount && this.count > 1) {
                JsonObject json = new JsonObject();
                json.add("item", item);
                json.addProperty("count", (Number)this.count);
                return json;
            }
            return item;
        }

        public OfItem(Item item, int count) {
            this.item = item;
            this.count = count;
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }

    private static class OfTagPreference
    extends ItemOutput {
        private final TagKey<Item> tag;
        private final int count;
        @Nullable
        private final CompoundTag nbt;
        private ItemStack cachedResult = null;

        @Override
        public ItemStack get() {
            if (this.cachedResult == null) {
                Optional<Item> preference = TagPreference.getPreference(this.tag);
                if (preference.isEmpty()) {
                    return ItemStack.f_41583_;
                }
                this.cachedResult = new ItemStack((ItemLike)preference.orElseThrow(), this.count);
                if (this.nbt != null) {
                    this.cachedResult.m_41751_(this.nbt.m_6426_());
                }
            }
            return this.cachedResult;
        }

        @Override
        public JsonElement serialize(boolean writeCount) {
            JsonObject json = new JsonObject();
            if (!writeCount || this.count > 0) {
                json.addProperty("tag", this.tag.f_203868_().toString());
            }
            if (writeCount) {
                json.addProperty("count", (Number)this.count);
            }
            if (this.count > 0 && this.nbt != null) {
                json.add("nbt", (JsonElement)NBTLoadable.ALLOW_STRING.serialize(this.nbt));
            }
            return json;
        }

        public OfTagPreference(TagKey<Item> tag, int count, @Nullable CompoundTag nbt) {
            this.tag = tag;
            this.count = count;
            this.nbt = nbt;
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }

    public static enum Loadable implements RecordLoadable<ItemOutput>
    {
        OPTIONAL_ITEM(false, false),
        OPTIONAL_STACK(false, true),
        REQUIRED_ITEM(true, false),
        REQUIRED_STACK(true, true);

        private final boolean nonEmpty;
        private final boolean readCount;
        private final RecordLoadable<ItemStack> stack;

        private Loadable(boolean nonEmpty, boolean readCount) {
            this.nonEmpty = nonEmpty;
            this.readCount = readCount;
            this.stack = nonEmpty ? (readCount ? ItemStackLoadable.REQUIRED_STACK_NBT : ItemStackLoadable.REQUIRED_ITEM_NBT) : (readCount ? ItemStackLoadable.OPTIONAL_STACK_NBT : ItemStackLoadable.OPTIONAL_ITEM_NBT);
        }

        @Override
        public ItemOutput deserialize(JsonObject json, TypedMap context) {
            if (json.has("tag")) {
                TagKey tag = (TagKey)Loadables.ITEM_TAG.getIfPresent(json, "tag", context);
                int count = 1;
                if (this.readCount) {
                    count = IntLoadable.FROM_ONE.getOrDefault(json, "count", 1, context);
                }
                return ItemOutput.fromTag((TagKey<Item>)tag, count, NBTLoadable.ALLOW_STRING.getOrDefault(json, "nbt", null));
            }
            return ItemOutput.fromStack(this.stack.deserialize(json, context));
        }

        @Override
        public ItemOutput convert(JsonElement element, String key, TypedMap context) {
            if (element.isJsonPrimitive()) {
                return ItemOutput.fromStack(this.stack.convert(element, key, context));
            }
            return this.deserialize(GsonHelper.m_13918_((JsonElement)element, (String)key), context);
        }

        @Override
        public void serialize(ItemOutput object, JsonObject json) {
            JsonElement element = this.serialize(object);
            if (element.isJsonObject()) {
                for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                    json.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            } else {
                json.add("item", element);
            }
        }

        @Override
        public JsonElement serialize(ItemOutput output) {
            if (this.nonEmpty && output.isEmpty()) {
                throw new IllegalArgumentException("ItemOutput cannot be empty for this recipe");
            }
            return output.serialize(this.readCount);
        }

        @Override
        public ItemOutput decode(FriendlyByteBuf buffer, TypedMap context) {
            return ItemOutput.fromStack((ItemStack)this.stack.decode(buffer, context));
        }

        @Override
        public void encode(FriendlyByteBuf buffer, ItemOutput object) {
            this.stack.encode(buffer, object.get());
        }

        public ItemOutput getOrEmpty(JsonObject parent, String key) {
            return this.getOrDefault(parent, key, EMPTY);
        }

        public <P> LoadableField<ItemOutput, P> emptyField(String key, boolean serializeDefault, Function<P, ItemOutput> getter) {
            return this.defaultField(key, EMPTY, serializeDefault, getter);
        }

        public <P> LoadableField<ItemOutput, P> emptyField(String key, Function<P, ItemOutput> getter) {
            return this.emptyField(key, false, getter);
        }
    }
}

