/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.Streamable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.array.ObjectArrayLoadable;
import slimeknights.mantle.data.loadable.field.DefaultingField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.NullableField;
import slimeknights.mantle.data.loadable.field.RequiredField;
import slimeknights.mantle.data.loadable.field.TryDirectField;
import slimeknights.mantle.data.loadable.mapping.AnyCollectionLoadable;
import slimeknights.mantle.data.loadable.mapping.ListLoadable;
import slimeknights.mantle.data.loadable.mapping.MappedLoadable;
import slimeknights.mantle.data.loadable.mapping.SetLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public interface Loadable<T>
extends JsonDeserializer<T>,
JsonSerializer<T>,
Streamable<T> {
    public T convert(JsonElement var1, String var2, TypedMap var3);

    @ApiStatus.NonExtendable
    default public T convert(JsonElement element, String key) {
        return this.convert(element, key, TypedMap.EMPTY);
    }

    public JsonElement serialize(T var1);

    @ApiStatus.OverrideOnly
    default public T deserialize(JsonElement json, Type type, JsonDeserializationContext context) {
        return this.convert(json, type.getTypeName(), TypedMap.EMPTY);
    }

    @ApiStatus.OverrideOnly
    default public JsonElement serialize(T object, Type type, JsonSerializationContext context) {
        return this.serialize(object);
    }

    @ApiStatus.NonExtendable
    default public T getIfPresent(JsonObject parent, String key, TypedMap context) {
        if (parent.has(key)) {
            return this.convert(parent.get(key), key, context);
        }
        throw new JsonSyntaxException("Missing JSON field '" + key + "'");
    }

    @ApiStatus.NonExtendable
    default public T getIfPresent(JsonObject parent, String key) {
        return this.getIfPresent(parent, key, TypedMap.EMPTY);
    }

    @Nullable
    @ApiStatus.NonExtendable
    @Contract(value="_, _, !null, _ -> !null")
    default public T getOrDefault(JsonObject parent, String key, @Nullable T defaultValue, TypedMap context) {
        JsonElement element = parent.get(key);
        if (element != null && !element.isJsonNull()) {
            return this.convert(element, key, context);
        }
        return defaultValue;
    }

    @Nullable
    @ApiStatus.NonExtendable
    @Contract(value="_, _, !null -> !null")
    default public T getOrDefault(JsonObject parent, String key, @Nullable T defaultValue) {
        return this.getOrDefault(parent, key, defaultValue, TypedMap.EMPTY);
    }

    default public <P> LoadableField<T, P> requiredField(String key, Function<P, T> getter) {
        return new RequiredField<T, P>(this, key, false, getter);
    }

    default public <P> LoadableField<T, P> nullableField(String key, Function<P, T> getter) {
        return new NullableField<T, P>(this, key, getter);
    }

    default public <P> LoadableField<T, P> defaultField(String key, T defaultValue, boolean serializeDefault, Function<P, T> getter) {
        return new DefaultingField<T, P>(this, key, defaultValue, serializeDefault, getter);
    }

    default public <P> LoadableField<T, P> defaultField(String key, T defaultValue, Function<P, T> getter) {
        return this.defaultField(key, defaultValue, false, getter);
    }

    default public <P> LoadableField<T, P> tryDirectField(String key, Function<P, T> getter, String ... conflicts) {
        return new TryDirectField<T, P>(this, key, getter, conflicts);
    }

    default public ArrayLoadable<T[]> array(IntFunction<T[]> constructor, boolean allowNull, int minSize, int maxSize) {
        return new ObjectArrayLoadable(this, constructor, minSize, maxSize, allowNull);
    }

    default public ArrayLoadable<T[]> array(IntFunction<T[]> constructor, boolean allowNull, int minSize) {
        return this.array(constructor, allowNull, minSize, Integer.MAX_VALUE);
    }

    default public ArrayLoadable<List<T>> list(int minSize) {
        return new ListLoadable(this, minSize);
    }

    default public ArrayLoadable<List<T>> list() {
        return this.list(1);
    }

    default public ArrayLoadable<Set<T>> set(int minSize) {
        return new SetLoadable(this, minSize);
    }

    default public ArrayLoadable<Set<T>> set() {
        return this.set(1);
    }

    default public <K> Loadable<Map<K, T>> mapWithKeys(int minSize, Function<T, K> keyGetter) {
        return AnyCollectionLoadable.setBacked(this, minSize).mapWithKeys(keyGetter);
    }

    default public <V> Loadable<Map<T, V>> mapWithValues(int minSize, Function<T, V> valueGetter) {
        return AnyCollectionLoadable.setBacked(this, minSize).mapWithValues(valueGetter);
    }

    default public <M> Loadable<M> xmap(BiFunction<T, ErrorFactory, M> from, BiFunction<M, ErrorFactory, T> to) {
        return MappedLoadable.of(this, from, to);
    }

    default public <M> Loadable<M> comapFlatMap(BiFunction<T, ErrorFactory, M> from, Function<M, T> to) {
        return this.xmap(from, MappedLoadable.flatten(to));
    }

    default public <M> Loadable<M> flatComap(Function<T, M> from, BiFunction<M, ErrorFactory, T> to) {
        return this.xmap(MappedLoadable.flatten(from), to);
    }

    default public <M> Loadable<M> flatXmap(Function<T, M> from, Function<M, T> to) {
        return this.xmap(MappedLoadable.flatten(from), MappedLoadable.flatten(to));
    }

    default public Loadable<T> validate(BiFunction<T, ErrorFactory, T> validator) {
        return this.xmap(validator, validator);
    }
}

