/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate;

import java.util.List;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.registry.DefaultingLoaderRegistry;

public class PredicateRegistry<T>
extends DefaultingLoaderRegistry<IJsonPredicate<T>> {
    private final RecordLoadable<InvertedJsonPredicate> invertedLoader;
    private final RecordLoadable<AndJsonPredicate> andLoader;
    private final RecordLoadable<OrJsonPredicate> orLoader;

    public PredicateRegistry(String name, IJsonPredicate<T> defaultInstance) {
        super(name, defaultInstance, true);
        ArrayLoadable<List<List>> list = this.list(2);
        this.invertedLoader = RecordLoadable.create(this.directField("inverted_type", p -> p.predicate), x$0 -> new InvertedJsonPredicate(x$0));
        this.andLoader = RecordLoadable.create(list.requiredField("predicates", p -> p.children), x$0 -> new AndJsonPredicate(x$0));
        this.orLoader = RecordLoadable.create(list.requiredField("predicates", p -> p.children), x$0 -> new OrJsonPredicate(x$0));
        this.register(Mantle.getResource("any"), defaultInstance.getLoader());
        this.register(Mantle.getResource("inverted"), this.invertedLoader);
        this.register(Mantle.getResource("and"), this.andLoader);
        this.register(Mantle.getResource("or"), this.orLoader);
    }

    public IJsonPredicate<T> invert(IJsonPredicate<T> predicate) {
        return new InvertedJsonPredicate(predicate);
    }

    public IJsonPredicate<T> and(List<IJsonPredicate<T>> predicates) {
        return new AndJsonPredicate(predicates);
    }

    public IJsonPredicate<T> or(List<IJsonPredicate<T>> predicates) {
        return new OrJsonPredicate(predicates);
    }

    public class InvertedJsonPredicate
    implements IJsonPredicate<T> {
        private final IJsonPredicate<T> predicate;

        @Override
        public boolean matches(T input) {
            return !this.predicate.matches(input);
        }

        @Override
        public RecordLoadable<? extends IJsonPredicate<T>> getLoader() {
            return PredicateRegistry.this.invertedLoader;
        }

        @Override
        public IJsonPredicate<T> inverted() {
            return this.predicate;
        }

        public InvertedJsonPredicate(IJsonPredicate<T> predicate) {
            this.predicate = predicate;
        }
    }

    public class AndJsonPredicate
    implements IJsonPredicate<T> {
        private final List<IJsonPredicate<T>> children;

        @Override
        public boolean matches(T input) {
            for (IJsonPredicate child : this.children) {
                if (child.matches(input)) continue;
                return false;
            }
            return true;
        }

        @Override
        public IJsonPredicate<T> inverted() {
            return PredicateRegistry.this.invert(this);
        }

        @Override
        public RecordLoadable<? extends IJsonPredicate<T>> getLoader() {
            return PredicateRegistry.this.andLoader;
        }

        public AndJsonPredicate(List<IJsonPredicate<T>> children) {
            this.children = children;
        }
    }

    public class OrJsonPredicate
    implements IJsonPredicate<T> {
        private final List<IJsonPredicate<T>> children;

        @Override
        public boolean matches(T input) {
            for (IJsonPredicate child : this.children) {
                if (!child.matches(input)) continue;
                return true;
            }
            return false;
        }

        @Override
        public IJsonPredicate<T> inverted() {
            return PredicateRegistry.this.invert(this);
        }

        @Override
        public RecordLoadable<? extends IJsonPredicate<T>> getLoader() {
            return PredicateRegistry.this.orLoader;
        }

        public OrJsonPredicate(List<IJsonPredicate<T>> children) {
            this.children = children;
        }
    }
}

