/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.joml.Matrix4f;
import slimeknights.mantle.Mantle;

public class SimpleBlockModel
implements IUnbakedGeometry<SimpleBlockModel> {
    public static final IGeometryLoader<SimpleBlockModel> LOADER = SimpleBlockModel::deserialize;
    static final ResourceLocation BAKE_LOCATION = Mantle.getResource("dynamic_model_baking");
    @Nullable
    private ResourceLocation parentLocation;
    private final List<BlockElement> parts;
    private final Map<String, Either<Material, String>> textures;
    private BlockModel parent;

    public SimpleBlockModel(@Nullable ResourceLocation parentLocation, Map<String, Either<Material, String>> textures, List<BlockElement> parts) {
        this.parts = parts;
        this.textures = textures;
        this.parentLocation = parentLocation;
    }

    public SimpleBlockModel(SimpleBlockModel base) {
        this.parts = base.parts;
        this.textures = base.textures;
        this.parentLocation = base.parentLocation;
        this.parent = base.parent;
    }

    public List<BlockElement> getElements() {
        return this.parts.isEmpty() && this.parent != null ? this.parent.m_111436_() : this.parts;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext owner) {
        if (this.parent != null || this.parentLocation == null) {
            return;
        }
        LinkedHashSet chain = Sets.newLinkedHashSet();
        this.parent = SimpleBlockModel.getParent(modelGetter, chain, this.parentLocation, owner.getModelName());
        if (this.parent == null) {
            this.parent = SimpleBlockModel.getMissing(modelGetter);
            this.parentLocation = ModelBakery.f_119230_;
        }
        BlockModel link = this.parent;
        while (link.f_111419_ != null && link.f_111418_ == null) {
            chain.add(link);
            link.f_111418_ = SimpleBlockModel.getParent(modelGetter, chain, link.f_111419_, link.f_111416_);
            if (link.f_111418_ == null) {
                link.f_111418_ = SimpleBlockModel.getMissing(modelGetter);
                link.f_111419_ = ModelBakery.f_119230_;
            }
            link = link.f_111418_;
        }
    }

    @Nullable
    private static BlockModel getParent(Function<ResourceLocation, UnbakedModel> modelGetter, Set<UnbakedModel> chain, ResourceLocation location, String name) {
        UnbakedModel unbaked = modelGetter.apply(location);
        if (unbaked == null) {
            Mantle.logger.warn("No parent '{}' while loading model '{}'", (Object)location, (Object)name);
            return null;
        }
        if (chain.contains(unbaked)) {
            Mantle.logger.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)name, (Object)chain.stream().map(Object::toString).collect(Collectors.joining(" -> ")), (Object)location);
            return null;
        }
        if (!(unbaked instanceof BlockModel)) {
            throw new IllegalStateException("BlockModel parent has to be a block model.");
        }
        return (BlockModel)unbaked;
    }

    @Nonnull
    private static BlockModel getMissing(Function<ResourceLocation, UnbakedModel> modelGetter) {
        UnbakedModel model = modelGetter.apply((ResourceLocation)ModelBakery.f_119230_);
        if (!(model instanceof BlockModel)) {
            throw new IllegalStateException("Failed to load missing model");
        }
        return (BlockModel)model;
    }

    public static SimpleBakedModel.Builder bakedBuilder(IGeometryBakingContext owner, ItemOverrides overrides) {
        return new SimpleBakedModel.Builder(owner.useAmbientOcclusion(), owner.useBlockLight(), owner.isGui3d(), owner.getTransforms(), overrides);
    }

    public static void bakePart(SimpleBakedModel.Builder builder, IGeometryBakingContext owner, BlockElement part, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, IQuadTransformer quadTransformer, ResourceLocation location) {
        for (Direction direction : part.f_111310_.keySet()) {
            BlockElementFace face = (BlockElementFace)part.f_111310_.get(direction);
            String texture = face.f_111356_;
            if (texture.charAt(0) == '#') {
                texture = texture.substring(1);
            }
            TextureAtlasSprite sprite = spriteGetter.apply(owner.getMaterial(texture));
            BakedQuad bakedQuad = BlockModel.m_111437_((BlockElement)part, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)transform, (ResourceLocation)location);
            quadTransformer.processInPlace(bakedQuad);
            if (face.f_111354_ == null) {
                builder.m_119526_(bakedQuad);
                continue;
            }
            builder.m_119530_(Direction.m_252919_((Matrix4f)transform.m_6189_().m_252783_(), (Direction)face.f_111354_), bakedQuad);
        }
    }

    public static RenderTypeGroup getRenderTypeGroup(IGeometryBakingContext owner) {
        ResourceLocation renderTypeHint = owner.getRenderTypeHint();
        return renderTypeHint != null ? owner.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
    }

    public static IQuadTransformer applyTransform(ModelState modelState, Transformation transformation) {
        if (transformation.isIdentity()) {
            return QuadTransformers.empty();
        }
        return UnbakedGeometryHelper.applyRootTransform((ModelState)modelState, (Transformation)transformation);
    }

    public static BakedModel bakeModel(IGeometryBakingContext owner, List<BlockElement> elements, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.getMaterial("particle"));
        SimpleBakedModel.Builder builder = SimpleBlockModel.bakedBuilder(owner, overrides).m_119528_(particle);
        IQuadTransformer quadTransformer = SimpleBlockModel.applyTransform(transform, owner.getRootTransform());
        for (BlockElement part : elements) {
            SimpleBlockModel.bakePart(builder, owner, part, spriteGetter, transform, quadTransformer, location);
        }
        return builder.build(SimpleBlockModel.getRenderTypeGroup(owner));
    }

    public static BakedModel bakeDynamic(IGeometryBakingContext owner, List<BlockElement> elements, ModelState transform) {
        return SimpleBlockModel.bakeModel(owner, elements, Material::m_119204_, transform, ItemOverrides.f_111734_, BAKE_LOCATION);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        return SimpleBlockModel.bakeModel(owner, this.getElements(), spriteGetter, transform, overrides, location);
    }

    public BakedModel bakeDynamic(IGeometryBakingContext owner, ModelState transform) {
        return SimpleBlockModel.bakeDynamic(owner, this.getElements(), transform);
    }

    public static SimpleBlockModel deserialize(JsonObject json, JsonDeserializationContext context) {
        ImmutableMap textureMap;
        ResourceLocation parent;
        String parentName = GsonHelper.m_13851_((JsonObject)json, (String)"parent", (String)"");
        ResourceLocation resourceLocation = parent = parentName.isEmpty() ? null : new ResourceLocation(parentName);
        if (json.has("textures")) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            ResourceLocation atlas = InventoryMenu.f_39692_;
            JsonObject textures = GsonHelper.m_13930_((JsonObject)json, (String)"textures");
            for (Map.Entry entry : textures.entrySet()) {
                builder.put((Object)((String)entry.getKey()), (Object)BlockModel.Deserializer.m_111503_((ResourceLocation)atlas, (String)((JsonElement)entry.getValue()).getAsString()));
            }
            textureMap = builder.build();
        } else {
            textureMap = Collections.emptyMap();
        }
        List<Object> parts = json.has("elements") ? SimpleBlockModel.getModelElements(context, (JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"elements"), "elements") : Collections.emptyList();
        return new SimpleBlockModel(parent, (Map<String, Either<Material, String>>)textureMap, (List<BlockElement>)parts);
    }

    public static List<BlockElement> getModelElements(JsonDeserializationContext context, JsonElement array, String name) {
        if (array.isJsonObject()) {
            return ImmutableList.of((Object)((BlockElement)context.deserialize((JsonElement)array.getAsJsonObject(), BlockElement.class)));
        }
        if (array.isJsonArray()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement json : array.getAsJsonArray()) {
                builder.add((Object)((BlockElement)context.deserialize(json, BlockElement.class)));
            }
            return builder.build();
        }
        throw new JsonSyntaxException("Missing " + name + ", expected to find a JsonArray or JsonObject");
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.parentLocation;
    }

    public Map<String, Either<Material, String>> getTextures() {
        return this.textures;
    }

    public BlockModel getParent() {
        return this.parent;
    }
}

