/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;

public class FluidTransferHelper {
    private static final String KEY_FILLED = Mantle.makeDescriptionId("block", "tank.filled");
    private static final String KEY_DRAINED = Mantle.makeDescriptionId("block", "tank.drained");

    public static SoundEvent getSound(FluidStack fluid, SoundAction action, SoundEvent fallback) {
        SoundEvent event = fluid.getFluid().getFluidType().getSound(fluid, action);
        if (event == null) {
            return fallback;
        }
        return event;
    }

    public static SoundEvent getEmptySound(FluidStack fluid) {
        return FluidTransferHelper.getSound(fluid, SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_);
    }

    public static SoundEvent getFillSound(FluidStack fluid) {
        return FluidTransferHelper.getSound(fluid, SoundActions.BUCKET_FILL, SoundEvents.f_11781_);
    }

    public static FluidStack tryTransfer(IFluidHandler input, IFluidHandler output, int maxFill) {
        return FluidTransferHelper.tryTransfer(input, output, input.drain(maxFill, IFluidHandler.FluidAction.SIMULATE));
    }

    public static FluidStack tryTransfer(IFluidHandler input, IFluidHandler output, FluidStack fluid) {
        int simulatedFill;
        if (!fluid.isEmpty() && (simulatedFill = output.fill(fluid.copy(), IFluidHandler.FluidAction.SIMULATE)) > 0) {
            int actualFill;
            FluidStack drainedFluid = input.drain(new FluidStack(fluid, simulatedFill), IFluidHandler.FluidAction.EXECUTE);
            if (!drainedFluid.isEmpty() && (actualFill = output.fill(drainedFluid.copy(), IFluidHandler.FluidAction.EXECUTE)) < drainedFluid.getAmount()) {
                int toReturn = drainedFluid.getAmount() - actualFill;
                drainedFluid.setAmount(actualFill);
                int returned = input.fill(new FluidStack(drainedFluid, toReturn), IFluidHandler.FluidAction.EXECUTE);
                if (returned < toReturn) {
                    Mantle.logger.error("Lost {} fluid during transfer", (Object)(toReturn - returned));
                }
            }
            return drainedFluid;
        }
        return FluidStack.EMPTY;
    }

    @Deprecated(forRemoval=true)
    public static boolean interactWithBucket(Level world, BlockPos pos, Player player, InteractionHand hand, Direction hit, Direction offset) {
        LazyOptional teCapability;
        BlockEntity te;
        if (player.m_21120_(hand).m_41720_() instanceof BucketItem && (te = world.m_7702_(pos)) != null && (teCapability = te.getCapability(ForgeCapabilities.FLUID_HANDLER, hit)).isPresent()) {
            return FluidTransferHelper.interactWithFilledBucket(world, pos, (IFluidHandler)teCapability.orElse((Object)EmptyFluidHandler.INSTANCE), player, hand, offset).hasContainer();
        }
        return false;
    }

    public static FluidInteractionResult interactWithFilledBucket(Level world, BlockPos pos, IFluidHandler handler, Player player, InteractionHand hand, Direction offset) {
        BucketItem bucket;
        Fluid fluid;
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item instanceof BucketItem && (fluid = (bucket = (BucketItem)item).getFluid()) != Fluids.f_76191_) {
            FluidStack fluidStack;
            if (!world.f_46443_ && handler.fill(fluidStack = new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                SoundEvent sound = FluidTransferHelper.getEmptySound(fluidStack);
                handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                bucket.m_142131_(player, world, held, pos.m_121945_(offset));
                world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_5661_((Component)Component.m_237110_((String)KEY_FILLED, (Object[])new Object[]{1000, fluidStack.getDisplayName()}), true);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, held.getCraftingRemainingItem());
                }
                return FluidInteractionResult.DRAINED_STACK;
            }
            return FluidInteractionResult.CONTAINER;
        }
        return FluidInteractionResult.MISSING;
    }

    public static void playEmptySound(Level world, BlockPos pos, Player player, FluidStack transferred) {
        world.m_5594_(null, pos, FluidTransferHelper.getEmptySound(transferred), SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)Component.m_237110_((String)KEY_FILLED, (Object[])new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
    }

    public static void playFillSound(Level world, BlockPos pos, Player player, FluidStack transferred) {
        world.m_5594_(null, pos, FluidTransferHelper.getFillSound(transferred), SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)Component.m_237110_((String)KEY_DRAINED, (Object[])new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
    }

    @Deprecated(forRemoval=true)
    public static boolean interactWithFluidItem(Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return FluidTransferHelper.interactWithContainer(world, pos, player, hand, hit).hasContainer();
    }

    public static FluidInteractionResult interactWithContainer(Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        LazyOptional teCapability;
        BlockEntity te;
        if (!player.m_21120_(hand).m_41619_() && (te = world.m_7702_(pos)) != null && (teCapability = te.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_())).isPresent()) {
            return FluidTransferHelper.interactWithContainer(world, pos, (IFluidHandler)teCapability.orElse((Object)EmptyFluidHandler.INSTANCE), player, hand);
        }
        return FluidInteractionResult.MISSING;
    }

    public static FluidInteractionResult interactWithContainer(Level world, BlockPos pos, IFluidHandler teHandler, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack)) {
            IFluidContainerTransfer.TransferResult result;
            FluidStack currentFluid;
            IFluidContainerTransfer transfer;
            if (!world.f_46443_ && (transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, currentFluid = teHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))) != null && (result = transfer.transfer(stack, currentFluid, teHandler, IFluidContainerTransfer.TransferDirection.AUTO)) != null) {
                if (result.didFill()) {
                    FluidTransferHelper.playFillSound(world, pos, player, result.fluid());
                } else {
                    FluidTransferHelper.playEmptySound(world, pos, player, result.fluid());
                }
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)result.stack()));
                return result.didFill() ? FluidInteractionResult.FILLED_STACK : FluidInteractionResult.DRAINED_STACK;
            }
            return FluidInteractionResult.CONTAINER;
        }
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        LazyOptional itemCapability = copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (itemCapability.isPresent()) {
            FluidInteractionResult result = FluidInteractionResult.CONTAINER;
            if (!world.f_46443_) {
                IFluidHandlerItem itemHandler = (IFluidHandlerItem)itemCapability.resolve().orElseThrow();
                FluidStack transferred = FluidTransferHelper.tryTransfer((IFluidHandler)itemHandler, teHandler, Integer.MAX_VALUE);
                if (!transferred.isEmpty()) {
                    FluidTransferHelper.playEmptySound(world, pos, player, transferred);
                    result = FluidInteractionResult.DRAINED_STACK;
                } else {
                    transferred = FluidTransferHelper.tryTransfer(teHandler, (IFluidHandler)itemHandler, Integer.MAX_VALUE);
                    if (!transferred.isEmpty()) {
                        FluidTransferHelper.playFillSound(world, pos, player, transferred);
                        result = FluidInteractionResult.FILLED_STACK;
                    }
                }
                if (!transferred.isEmpty()) {
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)itemHandler.getContainer()));
                }
            }
            return result;
        }
        return FluidInteractionResult.MISSING;
    }

    public static boolean interactWithTank(Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction direction = hit.m_82434_();
        return FluidTransferHelper.interactWithTank(world, pos, player, hand, direction, direction);
    }

    public static boolean interactWithTank(Level world, BlockPos pos, Player player, InteractionHand hand, Direction hit, Direction offset) {
        LazyOptional teCapability;
        BlockEntity te;
        if (!player.m_21120_(hand).m_41619_() && (te = world.m_7702_(pos)) != null && (teCapability = te.getCapability(ForgeCapabilities.FLUID_HANDLER, hit)).isPresent()) {
            IFluidHandler handler = (IFluidHandler)teCapability.orElse((Object)EmptyFluidHandler.INSTANCE);
            return FluidTransferHelper.interactWithContainer(world, pos, handler, player, hand).hasContainer() || FluidTransferHelper.interactWithFilledBucket(world, pos, handler, player, hand, offset).hasContainer();
        }
        return false;
    }

    public static ItemStack interactWithTankSlot(IFluidHandler teHandler, ItemStack stack, IFluidContainerTransfer.TransferDirection direction) {
        if (!stack.m_41619_()) {
            IFluidContainerTransfer.TransferResult result;
            FluidStack currentFluid;
            IFluidContainerTransfer transfer;
            if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack) && (transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, currentFluid = teHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))) != null && (result = transfer.transfer(stack, currentFluid, teHandler, direction)) != null) {
                stack.m_41774_(1);
                return result.stack();
            }
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            LazyOptional itemCapability = copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (itemCapability.isPresent()) {
                IFluidHandlerItem itemHandler = (IFluidHandlerItem)itemCapability.resolve().orElseThrow();
                FluidStack transferred = FluidStack.EMPTY;
                if (direction == IFluidContainerTransfer.TransferDirection.REVERSE) {
                    transferred = FluidTransferHelper.tryTransfer(teHandler, (IFluidHandler)itemHandler, Integer.MAX_VALUE);
                }
                if (direction.canEmpty() && transferred.isEmpty()) {
                    transferred = FluidTransferHelper.tryTransfer((IFluidHandler)itemHandler, teHandler, Integer.MAX_VALUE);
                }
                if (direction != IFluidContainerTransfer.TransferDirection.REVERSE && direction.canFill() && transferred.isEmpty()) {
                    transferred = FluidTransferHelper.tryTransfer(teHandler, (IFluidHandler)itemHandler, Integer.MAX_VALUE);
                }
                if (!transferred.isEmpty()) {
                    stack.m_41774_(1);
                    return itemHandler.getContainer();
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack fillFromTankSlot(IFluidHandler teHandler, ItemStack stack, FluidStack fluid) {
        if (!stack.m_41619_()) {
            IFluidHandlerItem itemHandler;
            FluidStack transferred;
            IFluidContainerTransfer.TransferResult result;
            IFluidContainerTransfer transfer;
            if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack) && (transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, fluid)) != null && (result = transfer.transfer(stack, fluid, teHandler, IFluidContainerTransfer.TransferDirection.FILL_ITEM)) != null) {
                stack.m_41774_(1);
                return result.stack();
            }
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            LazyOptional itemCapability = copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (itemCapability.isPresent() && !(transferred = FluidTransferHelper.tryTransfer(teHandler, (IFluidHandler)(itemHandler = (IFluidHandlerItem)itemCapability.resolve().orElseThrow()), fluid.copy())).isEmpty()) {
                stack.m_41774_(1);
                return itemHandler.getContainer();
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getOrTransferFilled(Player player, ItemStack emptyStack, ItemStack filledStack) {
        if (emptyStack.m_41619_()) {
            return filledStack;
        }
        if (!player.m_150109_().m_36054_(filledStack)) {
            player.m_36176_(filledStack, false);
        }
        return emptyStack;
    }

    private FluidTransferHelper() {
    }

    public static enum FluidInteractionResult {
        FILLED_STACK,
        DRAINED_STACK,
        CONTAINER,
        MISSING;


        public boolean didTransfer() {
            return this == FILLED_STACK || this == DRAINED_STACK;
        }

        public boolean hasContainer() {
            return this != MISSING;
        }
    }
}

