/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;

public class FluidTransferHelper {
    private static final String KEY_FILLED = Mantle.makeDescriptionId("block", "tank.filled");
    private static final String KEY_DRAINED = Mantle.makeDescriptionId("block", "tank.drained");

    public static SoundEvent getSound(FluidStack fluid, SoundAction action, SoundEvent fallback) {
        SoundEvent event = fluid.getFluid().getFluidType().getSound(fluid, action);
        if (event == null) {
            return fallback;
        }
        return event;
    }

    public static SoundEvent getEmptySound(FluidStack fluid) {
        return FluidTransferHelper.getSound(fluid, SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_);
    }

    public static SoundEvent getFillSound(FluidStack fluid) {
        return FluidTransferHelper.getSound(fluid, SoundActions.BUCKET_FILL, SoundEvents.f_11781_);
    }

    public static FluidStack tryTransfer(IFluidHandler input, IFluidHandler output, int maxFill) {
        return FluidTransferHelper.tryTransfer(input, output, input.drain(maxFill, IFluidHandler.FluidAction.SIMULATE));
    }

    public static FluidStack tryTransfer(IFluidHandler input, IFluidHandler output, FluidStack fluid) {
        int simulatedFill;
        if (!fluid.isEmpty() && (simulatedFill = output.fill(fluid.copy(), IFluidHandler.FluidAction.SIMULATE)) > 0) {
            int actualFill;
            FluidStack drainedFluid = input.drain(new FluidStack(fluid, simulatedFill), IFluidHandler.FluidAction.EXECUTE);
            if (!drainedFluid.isEmpty() && (actualFill = output.fill(drainedFluid.copy(), IFluidHandler.FluidAction.EXECUTE)) < drainedFluid.getAmount()) {
                int toReturn = drainedFluid.getAmount() - actualFill;
                drainedFluid.setAmount(actualFill);
                int returned = input.fill(new FluidStack(drainedFluid, toReturn), IFluidHandler.FluidAction.EXECUTE);
                if (returned < toReturn) {
                    Mantle.logger.error("Lost {} fluid during transfer", (Object)(toReturn - returned));
                }
            }
            return drainedFluid;
        }
        return FluidStack.EMPTY;
    }

    public static boolean interactWithBucket(Level world, BlockPos pos, Player player, InteractionHand hand, Direction hit, Direction offset) {
        BucketItem bucket;
        Fluid fluid;
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item instanceof BucketItem && (fluid = (bucket = (BucketItem)item).getFluid()) != Fluids.f_76191_) {
            BlockEntity te;
            if (!world.f_46443_ && (te = world.m_7702_(pos)) != null) {
                te.getCapability(ForgeCapabilities.FLUID_HANDLER, hit).ifPresent(handler -> {
                    FluidStack fluidStack = new FluidStack(bucket.getFluid(), 1000);
                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                        SoundEvent sound = FluidTransferHelper.getEmptySound(fluidStack);
                        handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        bucket.m_142131_(player, world, held, pos.m_121945_(offset));
                        world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                        player.m_5661_((Component)Component.m_237110_((String)KEY_FILLED, (Object[])new Object[]{1000, fluidStack.getDisplayName()}), true);
                        if (!player.m_7500_()) {
                            player.m_21008_(hand, held.getCraftingRemainingItem());
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    public static void playEmptySound(Level world, BlockPos pos, Player player, FluidStack transferred) {
        world.m_5594_(null, pos, FluidTransferHelper.getEmptySound(transferred), SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)Component.m_237110_((String)KEY_FILLED, (Object[])new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
    }

    public static void playFillSound(Level world, BlockPos pos, Player player, FluidStack transferred) {
        world.m_5594_(null, pos, FluidTransferHelper.getFillSound(transferred), SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)Component.m_237110_((String)KEY_DRAINED, (Object[])new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
    }

    public static boolean interactWithFluidItem(Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        LazyOptional teCapability;
        BlockEntity te;
        ItemStack stack = player.m_21120_(hand);
        Direction face = hit.m_82434_();
        if (!stack.m_41619_() && (te = world.m_7702_(pos)) != null && (teCapability = te.getCapability(ForgeCapabilities.FLUID_HANDLER, face)).isPresent()) {
            IFluidHandler teHandler = (IFluidHandler)teCapability.orElse((Object)EmptyFluidHandler.INSTANCE);
            if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack)) {
                IFluidContainerTransfer.TransferResult result;
                FluidStack currentFluid;
                IFluidContainerTransfer transfer;
                if (!world.f_46443_ && (transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, currentFluid = teHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))) != null && (result = transfer.transfer(stack, currentFluid, teHandler, IFluidContainerTransfer.TransferDirection.AUTO)) != null) {
                    if (result.didFill()) {
                        FluidTransferHelper.playFillSound(world, pos, player, result.fluid());
                    } else {
                        FluidTransferHelper.playEmptySound(world, pos, player, result.fluid());
                    }
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)result.stack()));
                }
                return true;
            }
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            LazyOptional itemCapability = copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (itemCapability.isPresent()) {
                if (!world.f_46443_) {
                    IFluidHandlerItem itemHandler = (IFluidHandlerItem)itemCapability.resolve().orElseThrow();
                    FluidStack transferred = FluidTransferHelper.tryTransfer((IFluidHandler)itemHandler, teHandler, Integer.MAX_VALUE);
                    if (!transferred.isEmpty()) {
                        FluidTransferHelper.playEmptySound(world, pos, player, transferred);
                    } else {
                        transferred = FluidTransferHelper.tryTransfer(teHandler, (IFluidHandler)itemHandler, Integer.MAX_VALUE);
                        if (!transferred.isEmpty()) {
                            FluidTransferHelper.playFillSound(world, pos, player, transferred);
                        }
                    }
                    if (!transferred.isEmpty()) {
                        player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)itemHandler.getContainer()));
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static boolean interactWithTank(Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return FluidTransferHelper.interactWithFluidItem(world, pos, player, hand, hit) || FluidTransferHelper.interactWithBucket(world, pos, player, hand, hit.m_82434_(), hit.m_82434_());
    }

    public static ItemStack interactWithTankSlot(IFluidHandler teHandler, ItemStack stack, IFluidContainerTransfer.TransferDirection direction) {
        if (!stack.m_41619_()) {
            IFluidContainerTransfer.TransferResult result;
            FluidStack currentFluid;
            IFluidContainerTransfer transfer;
            if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack) && (transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, currentFluid = teHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))) != null && (result = transfer.transfer(stack, currentFluid, teHandler, direction)) != null) {
                stack.m_41774_(1);
                return result.stack();
            }
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            LazyOptional itemCapability = copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (itemCapability.isPresent()) {
                IFluidHandlerItem itemHandler = (IFluidHandlerItem)itemCapability.resolve().orElseThrow();
                FluidStack transferred = FluidStack.EMPTY;
                if (direction == IFluidContainerTransfer.TransferDirection.REVERSE) {
                    transferred = FluidTransferHelper.tryTransfer(teHandler, (IFluidHandler)itemHandler, Integer.MAX_VALUE);
                }
                if (direction.canEmpty() && transferred.isEmpty()) {
                    transferred = FluidTransferHelper.tryTransfer((IFluidHandler)itemHandler, teHandler, Integer.MAX_VALUE);
                }
                if (direction != IFluidContainerTransfer.TransferDirection.REVERSE && direction.canFill() && transferred.isEmpty()) {
                    transferred = FluidTransferHelper.tryTransfer(teHandler, (IFluidHandler)itemHandler, Integer.MAX_VALUE);
                }
                if (!transferred.isEmpty()) {
                    stack.m_41774_(1);
                    return itemHandler.getContainer();
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack fillFromTankSlot(IFluidHandler teHandler, ItemStack stack, FluidStack fluid) {
        if (!stack.m_41619_()) {
            IFluidHandlerItem itemHandler;
            FluidStack transferred;
            IFluidContainerTransfer.TransferResult result;
            IFluidContainerTransfer transfer;
            if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack) && (transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, fluid)) != null && (result = transfer.transfer(stack, fluid, teHandler, IFluidContainerTransfer.TransferDirection.FILL_ITEM)) != null) {
                stack.m_41774_(1);
                return result.stack();
            }
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            LazyOptional itemCapability = copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (itemCapability.isPresent() && !(transferred = FluidTransferHelper.tryTransfer(teHandler, (IFluidHandler)(itemHandler = (IFluidHandlerItem)itemCapability.resolve().orElseThrow()), fluid.copy())).isEmpty()) {
                stack.m_41774_(1);
                return itemHandler.getContainer();
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getOrTransferFilled(Player player, ItemStack emptyStack, ItemStack filledStack) {
        if (emptyStack.m_41619_()) {
            return filledStack;
        }
        if (!player.m_150109_().m_36054_(filledStack)) {
            player.m_36176_(filledStack, false);
        }
        return emptyStack;
    }

    private FluidTransferHelper() {
    }
}

