/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.gson.GenericRegisteredSerializer;

public interface IFluidContainerTransfer
extends GenericRegisteredSerializer.IJsonSerializable {
    public void addRepresentativeItems(Consumer<Item> var1);

    public boolean matches(ItemStack var1, FluidStack var2);

    @Deprecated(forRemoval=true)
    @Nullable
    public TransferResult transfer(ItemStack var1, FluidStack var2, IFluidHandler var3);

    @Nullable
    default public TransferResult transfer(ItemStack stack, FluidStack fluid, IFluidHandler handler, TransferDirection direction) {
        return this.transfer(stack, fluid, handler);
    }

    public record TransferResult(ItemStack stack, FluidStack fluid, boolean didFill) {
    }

    public static interface WithDirection
    extends IFluidContainerTransfer {
        @Override
        public TransferResult transfer(ItemStack var1, FluidStack var2, IFluidHandler var3, TransferDirection var4);

        @Override
        @Deprecated(forRemoval=true)
        default public TransferResult transfer(ItemStack stack, FluidStack fluid, IFluidHandler handler) {
            return this.transfer(stack, fluid, handler, TransferDirection.AUTO);
        }
    }

    public static enum TransferDirection {
        AUTO,
        EMPTY_ITEM,
        FILL_ITEM,
        REVERSE;


        public boolean canEmpty() {
            return this != FILL_ITEM;
        }

        public boolean canFill() {
            return this != EMPTY_ITEM;
        }
    }
}

