/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.field;

import com.google.common.base.Objects;
import com.google.gson.JsonObject;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.AlwaysPresentLoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record DefaultingField<T, P>(Loadable<T> loadable, String key, T defaultValue, @Nullable BiPredicate<? super T, ? super T> skipSerialize, Function<P, T> getter) implements AlwaysPresentLoadableField<T, P>
{
    private static final BiPredicate<Object, Object> DEFAULT_SKIP = Objects::equal;

    public DefaultingField(Loadable<T> loadable, String key, T defaultValue, boolean serializeDefault, Function<P, T> getter) {
        this(loadable, key, defaultValue, serializeDefault ? null : DEFAULT_SKIP, getter);
    }

    public boolean serializeDefault() {
        return this.skipSerialize == null;
    }

    @Override
    public T get(JsonObject json, String key, TypedMap context) {
        return this.loadable.getOrDefault(json, key, this.defaultValue, context);
    }

    @Override
    public void serialize(P parent, JsonObject json) {
        T object = this.getter.apply(parent);
        if (this.skipSerialize == null || !this.skipSerialize.test(this.defaultValue, object)) {
            json.add(this.key, this.loadable.serialize(object));
        }
    }
}

