/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public record FloatArrayLoadable(Loadable<Float> base, int minSize, int maxSize) implements ArrayLoadable.SizeRange<float[]>
{
    @Override
    public int getLength(float[] array) {
        return array.length;
    }

    @Override
    public float[] convertCompact(JsonElement element, String key, TypedMap context) {
        return new float[]{this.base.convert(element, key, context).floatValue()};
    }

    @Override
    public float[] convertArray(JsonArray array, String key, TypedMap context) {
        float[] result = new float[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.base.convert(array.get(i), key + "[" + i + "]", context).floatValue();
        }
        return result;
    }

    @Override
    public JsonElement serializeFirst(float[] object) {
        return this.base.serialize(Float.valueOf(object[0]));
    }

    @Override
    public void serializeAll(JsonArray array, float[] object) {
        for (float element : object) {
            array.add(this.base.serialize(Float.valueOf(element)));
        }
    }

    @Override
    public float[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        float[] array = new float[max];
        for (int i = 0; i < max; ++i) {
            array[i] = ((Float)this.base.decode(buffer, context)).floatValue();
        }
        return array;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, float[] array) {
        buffer.m_130130_(array.length);
        for (float element : array) {
            this.base.encode(buffer, Float.valueOf(element));
        }
    }
}

