/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public record DoubleArrayLoadable(Loadable<Double> base, int minSize, int maxSize) implements ArrayLoadable.SizeRange<double[]>
{
    @Override
    public int getLength(double[] array) {
        return array.length;
    }

    @Override
    public double[] convertCompact(JsonElement element, String key, TypedMap context) {
        return new double[]{this.base.convert(element, key, context)};
    }

    @Override
    public double[] convertArray(JsonArray array, String key, TypedMap context) {
        double[] result = new double[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.base.convert(array.get(i), key + "[" + i + "]", context);
        }
        return result;
    }

    @Override
    public JsonElement serializeFirst(double[] object) {
        return this.base.serialize(object[0]);
    }

    @Override
    public void serializeAll(JsonArray array, double[] object) {
        for (double element : object) {
            array.add(this.base.serialize(element));
        }
    }

    @Override
    public double[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        double[] array = new double[max];
        for (int i = 0; i < max; ++i) {
            array[i] = (Double)this.base.decode(buffer, context);
        }
        return array;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, double[] array) {
        buffer.m_130130_(array.length);
        for (double element : array) {
            this.base.encode(buffer, element);
        }
    }
}

