/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.mapping.CollectionLoadable;

public class AnyCollectionLoadable<T>
extends CollectionLoadable<T, Collection<T>> {
    private final Function<Collection<T>, Collection<T>> builder;

    public AnyCollectionLoadable(Loadable<T> base, int minSize, Function<Collection<T>, Collection<T>> builder) {
        super(base, minSize);
        this.builder = builder;
    }

    public static <T> AnyCollectionLoadable<T> listBacked(Loadable<T> base, int minSize) {
        return new AnyCollectionLoadable<T>(base, minSize, List::copyOf);
    }

    public static <T> AnyCollectionLoadable<T> setBacked(Loadable<T> base, int minSize) {
        return new AnyCollectionLoadable<T>(base, minSize, Set::copyOf);
    }

    @Override
    protected Collection<T> build(Collection<T> builder) {
        return this.builder.apply(builder);
    }

    public <K> Loadable<Map<K, T>> mapWithKeys(Function<T, K> keyGetter) {
        return this.flatXmap(collection -> collection.stream().collect(Collectors.toUnmodifiableMap(keyGetter, Function.identity())), Map::values);
    }

    public <V> Loadable<Map<T, V>> mapWithValues(Function<T, V> valueGetter) {
        return this.flatXmap(collection -> collection.stream().collect(Collectors.toUnmodifiableMap(Function.identity(), valueGetter)), Map::keySet);
    }
}

