/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.util.typed.TypedMap;

public interface ArrayLoadable<A>
extends Loadable<A> {
    public static final int COMPACT_OR_EMPTY = -2;
    public static final int COMPACT = -1;

    public boolean allowCompact();

    public void checkSize(String var1, int var2, ErrorFactory var3);

    public int getLength(A var1);

    public A convertCompact(JsonElement var1, String var2, TypedMap var3);

    public A convertArray(JsonArray var1, String var2, TypedMap var3);

    public JsonElement serializeFirst(A var1);

    public void serializeAll(JsonArray var1, A var2);

    @Override
    default public A convert(JsonElement element, String key, TypedMap context) {
        if (this.allowCompact() && !element.isJsonArray()) {
            return this.convertCompact(element, key, context);
        }
        JsonArray array = GsonHelper.m_13924_((JsonElement)element, (String)key);
        this.checkSize(key, array.size(), ErrorFactory.JSON_SYNTAX_ERROR);
        return this.convertArray(array, key, context);
    }

    @Override
    default public JsonElement serialize(A object) {
        JsonElement element;
        int length = this.getLength(object);
        if (this.allowCompact() && length == 1 && !(element = this.serializeFirst(object)).isJsonArray()) {
            return element;
        }
        this.checkSize("Collection", length, ErrorFactory.RUNTIME);
        JsonArray array = new JsonArray();
        this.serializeAll(array, object);
        return array;
    }

    public static interface SizeRange<A>
    extends ArrayLoadable<A> {
        public int minSize();

        public int maxSize();

        @Override
        default public boolean allowCompact() {
            return this.minSize() < 0;
        }

        @Override
        default public void checkSize(String key, int size, ErrorFactory error) {
            int minSize = this.minSize();
            minSize = minSize == -1 ? 1 : 0;
            int maxSize = this.maxSize();
            if (size < minSize || maxSize < size) {
                if (maxSize == Integer.MAX_VALUE) {
                    throw error.create(key + " must have at least " + minSize + " elements");
                }
                throw error.create(key + " must have between " + minSize + " and " + maxSize + " elements");
            }
        }
    }
}

