/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.field;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record NullableField<T, P>(Loadable<T> loadable, String key, Function<P, T> getter) implements LoadableField<T, P>
{
    @Override
    public T get(JsonObject json, TypedMap context) {
        return this.loadable.getOrDefault(json, this.key, null, context);
    }

    @Override
    public void serialize(P parent, JsonObject json) {
        T object = this.getter.apply(parent);
        if (object != null) {
            json.add(this.key, this.loadable.serialize(object));
        }
    }

    @Override
    public T decode(FriendlyByteBuf buffer, TypedMap context) {
        if (buffer.readBoolean()) {
            return (T)this.loadable.decode(buffer, context);
        }
        return null;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, P parent) {
        T object = this.getter.apply(parent);
        if (object != null) {
            buffer.writeBoolean(true);
            this.loadable.encode(buffer, object);
        } else {
            buffer.writeBoolean(false);
        }
    }
}

