/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.mapping.EnumMapLoadable;
import slimeknights.mantle.data.loadable.primitive.ResourceLocationLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public enum DisplayContextLoadable implements ResourceLocationLoadable<ItemDisplayContext>
{
    INSTANCE;


    @Override
    public ItemDisplayContext fromKey(ResourceLocation name, String key) {
        ItemDisplayContext value;
        IForgeRegistry registry = (IForgeRegistry)ForgeRegistries.DISPLAY_CONTEXTS.get();
        if (registry.containsKey(name) && (value = (ItemDisplayContext)registry.getValue(name)) != null) {
            return value;
        }
        throw new JsonSyntaxException("Unable to parse " + key + " as the ItemDisplayContext registry does not contain ID " + name);
    }

    @Override
    public ResourceLocation getKey(ItemDisplayContext object) {
        IForgeRegistry registry = (IForgeRegistry)ForgeRegistries.DISPLAY_CONTEXTS.get();
        ResourceLocation location = registry.getKey((Object)object);
        if (location == null) {
            throw new RuntimeException("ItemDisplayContext registry does not contain object " + object);
        }
        return location;
    }

    @Override
    public ItemDisplayContext decode(FriendlyByteBuf buffer, TypedMap context) {
        return (ItemDisplayContext)buffer.readRegistryIdUnsafe((IForgeRegistry)ForgeRegistries.DISPLAY_CONTEXTS.get());
    }

    @Override
    public void encode(FriendlyByteBuf buffer, ItemDisplayContext value) {
        buffer.writeRegistryIdUnsafe((IForgeRegistry)ForgeRegistries.DISPLAY_CONTEXTS.get(), (Object)value);
    }

    @Override
    public <V> Loadable<Map<ItemDisplayContext, V>> mapWithValues(Loadable<V> valueLoadable, int minSize) {
        return new EnumMapLoadable<ItemDisplayContext, V>(ItemDisplayContext.class, this, valueLoadable, minSize);
    }
}

