/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.primitive;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.mapping.MapLoadable;
import slimeknights.mantle.data.loadable.mapping.MappedLoadable;
import slimeknights.mantle.data.loadable.primitive.MaxLengthStringLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public interface StringLoadable<T>
extends Loadable<T> {
    public static final StringLoadable<String> DEFAULT = StringLoadable.maxLength(Short.MAX_VALUE);

    public static StringLoadable<String> maxLength(int maxLength) {
        return new MaxLengthStringLoadable(maxLength);
    }

    public T parseString(String var1, String var2);

    @Override
    default public T convert(JsonElement element, String key, TypedMap context) {
        return this.parseString(GsonHelper.m_13805_((JsonElement)element, (String)key), key);
    }

    public String getString(T var1);

    @Override
    default public JsonElement serialize(T object) {
        return new JsonPrimitive(this.getString(object));
    }

    default public <V> Loadable<Map<T, V>> mapWithValues(Loadable<V> valueLoadable, int minSize) {
        return new MapLoadable(this, valueLoadable, minSize);
    }

    default public <V> Loadable<Map<T, V>> mapWithValues(Loadable<V> valueLoadable) {
        return this.mapWithValues(valueLoadable, 1);
    }

    @Override
    default public <M> StringLoadable<M> xmap(BiFunction<T, ErrorFactory, M> from, BiFunction<M, ErrorFactory, T> to) {
        return MappedLoadable.of(this, from, to);
    }

    @Override
    default public <M> StringLoadable<M> comapFlatMap(BiFunction<T, ErrorFactory, M> from, Function<M, T> to) {
        return this.xmap((BiFunction)from, (BiFunction)MappedLoadable.flatten(to));
    }

    @Override
    default public <M> StringLoadable<M> flatComap(Function<T, M> from, BiFunction<M, ErrorFactory, T> to) {
        return this.xmap((BiFunction)MappedLoadable.flatten(from), (BiFunction)to);
    }

    @Override
    default public <M> StringLoadable<M> flatXmap(Function<T, M> from, Function<M, T> to) {
        return this.xmap((BiFunction)MappedLoadable.flatten(from), (BiFunction)MappedLoadable.flatten(to));
    }

    @Override
    default public Loadable<T> validate(BiFunction<T, ErrorFactory, T> validator) {
        return this.xmap(validator, validator);
    }
}

