/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.LogicHelper;

public class ColoredBlockModel
extends SimpleBlockModel {
    public static final IGeometryLoader<SimpleBlockModel> LOADER = ColoredBlockModel::deserialize;
    private final List<ColorData> colorData;

    public ColoredBlockModel(@Nullable ResourceLocation parentLocation, Map<String, Either<Material, String>> textures, List<BlockElement> parts, List<ColorData> colorData) {
        super(parentLocation, textures, parts);
        this.colorData = colorData;
    }

    public ColoredBlockModel(SimpleBlockModel base, List<ColorData> colorData) {
        super(base);
        this.colorData = colorData;
    }

    public static void bakePart(SimpleBakedModel.Builder builder, IGeometryBakingContext owner, BlockElement part, int emissivity, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transform, IQuadTransformer quadTransformer, boolean uvlock, ResourceLocation location) {
        for (Direction direction : part.f_111310_.keySet()) {
            BlockElementFace face = (BlockElementFace)part.f_111310_.get(direction);
            String texture = face.f_111356_;
            if (texture.charAt(0) == '#') {
                texture = texture.substring(1);
            }
            TextureAtlasSprite sprite = spriteGetter.apply(owner.getMaterial(texture));
            BakedQuad quad = ColoredBlockModel.bakeFace(part, face, sprite, direction, transform, uvlock, emissivity, location);
            quadTransformer.processInPlace(quad);
            if (face.f_111354_ == null) {
                builder.m_119526_(quad);
                continue;
            }
            builder.m_119530_(Direction.m_252919_((Matrix4f)transform.m_252783_(), (Direction)face.f_111354_), quad);
        }
    }

    public static BakedModel bakeModel(IGeometryBakingContext owner, List<BlockElement> elements, List<ColorData> colorData, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.getMaterial("particle"));
        SimpleBakedModel.Builder builder = ColoredBlockModel.bakedBuilder(owner, overrides).m_119528_(particle);
        int size = elements.size();
        IQuadTransformer quadTransformer = ColoredBlockModel.applyTransform(transform, owner.getRootTransform());
        Transformation transformation = transform.m_6189_();
        boolean uvlock = transform.m_7538_();
        for (int i = 0; i < size; ++i) {
            BlockElement part = elements.get(i);
            ColorData colors = LogicHelper.getOrDefault(colorData, i, ColorData.DEFAULT);
            if (colors.luminosity != -1 && !location.equals((Object)BAKE_LOCATION)) {
                Mantle.logger.warn("Using deprecated 'luminosity' field on ColoredBlockModel color data for {}, this will be removed in 1.20 in favor of Forge's 'emissivity'.", (Object)location);
            }
            IQuadTransformer partTransformer = colors.color == -1 ? quadTransformer : quadTransformer.andThen(ColoredBlockModel.applyColorQuadTransformer(colors.color));
            ColoredBlockModel.bakePart(builder, owner, part, colors.luminosity, spriteGetter, transformation, partTransformer, colors.isUvLock(uvlock), location);
        }
        return builder.build(ColoredBlockModel.getRenderTypeGroup(owner));
    }

    @Override
    public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return ColoredBlockModel.bakeModel(owner, this.getElements(), this.colorData, spriteGetter, modelTransform, overrides, modelLocation);
    }

    @Override
    public BakedModel bakeWithElements(IGeometryBakingContext owner, List<BlockElement> elements, ModelState transform) {
        return ColoredBlockModel.bakeModel(owner, elements, this.colorData, Material::m_119204_, transform, ItemOverrides.f_111734_, BAKE_LOCATION);
    }

    public static ColoredBlockModel deserialize(JsonObject json, JsonDeserializationContext context) {
        SimpleBlockModel model = SimpleBlockModel.deserialize(json, context);
        List<ColorData> colorData = json.has("colors") ? JsonHelper.parseList(json, "colors", ColorData::fromJson) : Collections.emptyList();
        return new ColoredBlockModel(model, colorData);
    }

    public static int swapColorRedBlue(int color) {
        return color & 0xFF00FF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000;
    }

    public static IQuadTransformer applyColorQuadTransformer(int color) {
        int abgr = ColoredBlockModel.swapColorRedBlue(color);
        return quad -> {
            int[] vertices = quad.m_111303_();
            for (int i = 0; i < 4; ++i) {
                vertices[i * IQuadTransformer.STRIDE + IQuadTransformer.COLOR] = abgr;
            }
        };
    }

    public static BakedQuad bakeFace(BlockElement part, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, Transformation transform, boolean uvlock, int emissivity, ResourceLocation location) {
        return ColoredBlockModel.bakeQuad(part.f_111308_, part.f_111309_, face, sprite, facing, transform, uvlock, part.f_111311_, part.f_111312_, emissivity, location);
    }

    public static BakedQuad bakeQuad(Vector3f posFrom, Vector3f posTo, BlockElementFace face, TextureAtlasSprite sprite, Direction facing, Transformation transform, boolean uvlock, @Nullable BlockElementRotation partRotation, boolean shade, int emissivity, ResourceLocation location) {
        BlockFaceUV faceUV = face.f_111357_;
        if (uvlock) {
            faceUV = FaceBakery.m_111581_((BlockFaceUV)face.f_111357_, (Direction)facing, (Transformation)transform, (ResourceLocation)location);
        }
        float[] originalUV = new float[faceUV.f_111387_.length];
        System.arraycopy(faceUV.f_111387_, 0, originalUV, 0, originalUV.length);
        float shrinkRatio = sprite.m_118417_();
        float u = (faceUV.f_111387_[0] + faceUV.f_111387_[0] + faceUV.f_111387_[2] + faceUV.f_111387_[2]) / 4.0f;
        float v = (faceUV.f_111387_[1] + faceUV.f_111387_[1] + faceUV.f_111387_[3] + faceUV.f_111387_[3]) / 4.0f;
        faceUV.f_111387_[0] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[0], (float)u);
        faceUV.f_111387_[2] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[2], (float)u);
        faceUV.f_111387_[1] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[1], (float)v);
        faceUV.f_111387_[3] = Mth.m_14179_((float)shrinkRatio, (float)faceUV.f_111387_[3], (float)v);
        int[] vertexData = BlockModel.f_111421_.m_111573_(faceUV, sprite, facing, BlockModel.f_111421_.m_111592_(posFrom, posTo), transform, partRotation, shade);
        Direction direction = FaceBakery.m_111612_((int[])vertexData);
        System.arraycopy(originalUV, 0, faceUV.f_111387_, 0, originalUV.length);
        if (partRotation == null) {
            BlockModel.f_111421_.m_111630_(vertexData, direction);
        }
        ForgeHooksClient.fillNormal((int[])vertexData, (Direction)direction);
        BakedQuad quad = new BakedQuad(vertexData, face.f_111355_, direction, sprite, shade);
        if (emissivity == -1) {
            emissivity = face.getFaceData().blockLight();
        }
        if (emissivity > 0) {
            QuadTransformers.settingEmissivity((int)emissivity).processInPlace(quad);
        }
        return quad;
    }

    public List<ColorData> getColorData() {
        return this.colorData;
    }

    public record ColorData(int color, @Deprecated int luminosity, @Nullable Boolean uvlock) {
        public static final ColorData DEFAULT = new ColorData(-1, -1, null);

        public boolean isUvLock(boolean defaultLock) {
            if (this.uvlock == null) {
                return defaultLock;
            }
            return this.uvlock;
        }

        public static ColorData fromJson(JsonObject json) {
            int color = ColorLoadable.ALPHA.getOrWhite(json, "color");
            int luminosity = GsonHelper.m_13824_((JsonObject)json, (String)"luminosity", (int)-1);
            Boolean uvlock = null;
            if (json.has("uvlock")) {
                uvlock = GsonHelper.m_13912_((JsonObject)json, (String)"uvlock");
            }
            return new ColorData(color, luminosity, uvlock);
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            if (this.color != -1) {
                json.add("color", ColorLoadable.ALPHA.serialize(this.color));
            }
            if (this.luminosity != -1) {
                json.addProperty("luminosity", (Number)this.luminosity);
            }
            if (this.uvlock != null) {
                json.addProperty("uvlock", this.uvlock);
            }
            return json;
        }
    }
}

