/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.primitive;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public class IntLoadable
implements Loadable<Integer> {
    public static final IntLoadable ANY_FULL = IntLoadable.range(Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final IntLoadable ANY_SHORT = IntLoadable.range(Short.MIN_VALUE, Short.MAX_VALUE);
    public static final IntLoadable FROM_MINUS_ONE = IntLoadable.range(-1, Short.MAX_VALUE);
    public static final IntLoadable FROM_ZERO = IntLoadable.min(0);
    public static final IntLoadable FROM_ONE = IntLoadable.min(1);
    private final int min;
    private final int max;
    private final IntNetwork network;

    public static IntLoadable range(int min, int max) {
        return new IntLoadable(min, max, IntNetwork.recommended(min, max));
    }

    public static IntLoadable min(int min) {
        return IntLoadable.range(min, Integer.MAX_VALUE);
    }

    protected int validate(int value, String key) {
        if (this.min <= value && value <= this.max) {
            return value;
        }
        if (this.min == Integer.MIN_VALUE) {
            throw new JsonSyntaxException(key + " must not be greater than " + this.max);
        }
        if (this.max == Integer.MAX_VALUE) {
            throw new JsonSyntaxException(key + " must not be less than " + this.min);
        }
        throw new JsonSyntaxException(key + " must be between " + this.min + " and " + this.max);
    }

    @Override
    public Integer convert(JsonElement element, String key, TypedMap context) {
        return this.validate(GsonHelper.m_13897_((JsonElement)element, (String)key), key);
    }

    @Override
    public JsonElement serialize(Integer value) {
        return new JsonPrimitive((Number)this.validate(value, "Value"));
    }

    @Override
    public Integer decode(FriendlyByteBuf buffer, TypedMap context) {
        return this.network.fromNetwork(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Integer object) {
        this.network.toNetwork(object, buffer);
    }

    public StringLoadable<Integer> asString(int radix) {
        return new StringIntLoadable(this.min, this.max, radix, this.network);
    }

    public IntLoadable(int min, int max, IntNetwork network) {
        this.min = min;
        this.max = max;
        this.network = network;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum IntNetwork {
        INT{

            @Override
            int fromNetwork(FriendlyByteBuf buffer) {
                return buffer.readInt();
            }

            @Override
            void toNetwork(int value, FriendlyByteBuf buffer) {
                buffer.writeInt(value);
            }
        }
        ,
        VAR_INT{

            @Override
            int fromNetwork(FriendlyByteBuf buffer) {
                return buffer.m_130242_();
            }

            @Override
            void toNetwork(int value, FriendlyByteBuf buffer) {
                buffer.m_130130_(value);
            }
        }
        ,
        SHORT{

            @Override
            int fromNetwork(FriendlyByteBuf buffer) {
                return buffer.readShort();
            }

            @Override
            void toNetwork(int value, FriendlyByteBuf buffer) {
                buffer.writeShort(value);
            }
        };


        abstract int fromNetwork(FriendlyByteBuf var1);

        abstract void toNetwork(int var1, FriendlyByteBuf var2);

        public static IntNetwork recommended(int min, int max) {
            if (min >= 0) {
                return VAR_INT;
            }
            if (min >= Short.MIN_VALUE && max <= Short.MAX_VALUE) {
                return SHORT;
            }
            return INT;
        }
    }

    private static class StringIntLoadable
    extends IntLoadable
    implements StringLoadable<Integer> {
        private final int radix;

        public StringIntLoadable(int min, int max, int radix, IntNetwork network) {
            super(min, max, network);
            if (radix < 2 || radix > 36) {
                throw new IllegalArgumentException("Invalid radix " + radix + ", must be between 2 and 36");
            }
            this.radix = radix;
        }

        @Override
        public Integer parseString(String value, String key) {
            try {
                return this.validate(Integer.parseInt(value, this.radix), key);
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException("Failed to parse integer at " + key, (Throwable)e);
            }
        }

        @Override
        public Integer convert(JsonElement element, String key, TypedMap context) {
            return this.parseString(GsonHelper.m_13805_((JsonElement)element, (String)key), key);
        }

        @Override
        public String getString(Integer value) {
            return Integer.toString(value, this.radix);
        }

        @Override
        public JsonElement serialize(Integer value) {
            return new JsonPrimitive(this.getString(value));
        }
    }
}

