/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.field.DirectField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.MergingRegistryField;
import slimeknights.mantle.data.registry.NamedComponentRegistry;
import slimeknights.mantle.util.typed.TypedMap;

public class GenericLoaderRegistry<T extends IHaveLoader>
implements RecordLoadable<T> {
    protected static final JsonObject EMPTY_OBJECT = new JsonObject();
    private final String name;
    protected final NamedComponentRegistry<RecordLoadable<? extends T>> loaders;
    protected final boolean compact;

    public GenericLoaderRegistry(String name, boolean compact) {
        this.name = name;
        this.compact = compact;
        this.loaders = new NamedComponentRegistry("Unknown " + name + " loader");
    }

    public void register(ResourceLocation name, RecordLoadable<? extends T> loader) {
        this.loaders.register(name, loader);
    }

    @Override
    public T convert(JsonElement element, String key, TypedMap context) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            return (T)((IHaveLoader)((RecordLoadable)this.loaders.getIfPresent(object, "type", context)).deserialize(object, context));
        }
        if (this.compact && element.isJsonPrimitive()) {
            EMPTY_OBJECT.entrySet().clear();
            return (T)((IHaveLoader)((RecordLoadable)this.loaders.convert(element, "type", context)).deserialize(EMPTY_OBJECT, context));
        }
        throw new JsonSyntaxException("Invalid " + this.name + " JSON at " + key + ", must be a JSON object" + (this.compact ? " or a string" : ""));
    }

    @Override
    public T deserialize(JsonObject json, TypedMap context) {
        return (T)((IHaveLoader)((RecordLoadable)this.loaders.getIfPresent(json, "type", context)).deserialize(json, context));
    }

    private <L> void serialize(RecordLoadable<L> loader, T src, JsonObject json) {
        JsonPrimitive type = new JsonPrimitive(this.loaders.getKey(loader).toString());
        json.add("type", (JsonElement)type);
        loader.serialize(src, json);
        if (json.get("type") != type) {
            throw new IllegalStateException(this.name + " serializer " + type.getAsString() + " modified the type key, this is not allowed as it breaks deserialization");
        }
    }

    @Override
    public JsonElement serialize(T src) {
        JsonObject json = new JsonObject();
        this.serialize(src.getLoader(), src, json);
        if (this.compact && json.entrySet().size() == 1) {
            return json.get("type");
        }
        return json;
    }

    @Override
    public void serialize(T object, JsonObject json) {
        this.serialize(object.getLoader(), object, json);
    }

    protected <L> void encode(RecordLoadable<L> loader, FriendlyByteBuf buffer, T src) {
        loader.encode(buffer, src);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T src) {
        RecordLoadable<? extends IHaveLoader> loader = src.getLoader();
        this.loaders.encode(buffer, loader);
        this.encode(loader, buffer, src);
    }

    @Override
    public T decode(FriendlyByteBuf buffer, TypedMap context) {
        return (T)((IHaveLoader)((RecordLoadable)this.loaders.decode(buffer, context)).decode(buffer, context));
    }

    @Override
    public <P> LoadableField<T, P> directField(Function<P, T> getter) {
        return new DirectField<T, P>(this, getter);
    }

    public <P> LoadableField<T, P> directField(String typeKey, Function<P, T> getter) {
        return new MergingRegistryField<T, P>(this, typeKey, getter);
    }

    public String toString() {
        return this.getClass().getName() + "('" + this.name + "')";
    }

    public String getName() {
        return this.name;
    }

    public static interface IHaveLoader {
        public RecordLoadable<? extends IHaveLoader> getLoader();
    }
}

