/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.typed.TypedMap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ColorLoadable implements StringLoadable<Integer>
{
    ALPHA{

        @Override
        public Integer parseString(String color, String key) {
            if (color.charAt(0) != '-') {
                try {
                    int length = color.length();
                    if (length == 8) {
                        return (int)Long.parseLong(color, 16);
                    }
                    if (length == 6) {
                        return 0xFF000000 | Integer.parseInt(color, 16);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new JsonSyntaxException("Invalid color '" + color + "' at " + key);
        }

        @Override
        public String getString(Integer color) {
            return String.format("%08X", color);
        }
    }
    ,
    NO_ALPHA{

        @Override
        public Integer parseString(String color, String key) {
            if (color.charAt(0) != '-' && color.length() == 6) {
                try {
                    return 0xFF000000 | Integer.parseInt(color, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new JsonSyntaxException("Invalid color '" + color + "' at " + key);
        }

        @Override
        public String getString(Integer color) {
            return String.format("%06X", color & 0xFFFFFF);
        }
    };


    @Override
    public Integer decode(FriendlyByteBuf buffer, TypedMap context) {
        return buffer.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Integer color) {
        buffer.writeInt(color.intValue());
    }

    public int getOrWhite(JsonObject parent, String key) {
        return this.getOrDefault(parent, key, -1);
    }
}

