/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.texture;

import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.util.IdExtender;
import slimeknights.mantle.util.JsonHelper;

public record FluidTexture(ResourceLocation still, ResourceLocation flowing, @Nullable ResourceLocation overlay, @Nullable ResourceLocation camera, int color) {
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("still", this.still.toString());
        json.addProperty("flowing", this.flowing.toString());
        if (this.overlay != null) {
            json.addProperty("overlay", this.overlay.toString());
        }
        if (this.camera != null) {
            json.addProperty("camera", this.camera.toString());
        }
        json.addProperty("color", String.format("%08X", this.color));
        return json;
    }

    public static FluidTexture deserialize(JsonObject json) {
        ResourceLocation still = JsonHelper.getResourceLocation(json, "still");
        ResourceLocation flowing = JsonHelper.getResourceLocation(json, "flowing");
        ResourceLocation overlay = JsonHelper.getResourceLocation(json, "overlay", null);
        ResourceLocation camera = null;
        if (json.has("camera")) {
            camera = (ResourceLocation)IdExtender.LocationExtender.INSTANCE.wrap(JsonHelper.getResourceLocation(json, "camera"), "textures/", ".png");
        }
        int color = ColorLoadable.ALPHA.getOrWhite(json, "color");
        return new FluidTexture(still, flowing, overlay, camera, color);
    }

    public static class Builder {
        private final FluidType fluid;
        private ResourceLocation still;
        private ResourceLocation flowing;
        @Nullable
        private ResourceLocation overlay = null;
        @Nullable
        private ResourceLocation camera = null;
        private int color = -1;

        public Builder wrapId(String prefix, String suffix, boolean overlay, boolean camera) {
            return this.textures((ResourceLocation)IdExtender.LocationExtender.INSTANCE.wrap(Objects.requireNonNull(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)this.fluid)), prefix, suffix), overlay, camera);
        }

        public Builder textures(ResourceLocation path, boolean overlay, boolean camera) {
            this.still((ResourceLocation)IdExtender.LocationExtender.INSTANCE.suffix(path, "still"));
            this.flowing((ResourceLocation)IdExtender.LocationExtender.INSTANCE.suffix(path, "flowing"));
            if (overlay) {
                this.overlay((ResourceLocation)IdExtender.LocationExtender.INSTANCE.suffix(path, "overlay"));
            }
            if (camera) {
                this.camera((ResourceLocation)IdExtender.LocationExtender.INSTANCE.suffix(path, "camera"));
            }
            return this;
        }

        public FluidTexture build() {
            if (this.still == null || this.flowing == null) {
                throw new IllegalStateException("Must set both stll and flowing");
            }
            return new FluidTexture(this.still, this.flowing, this.overlay, this.camera, this.color);
        }

        public Builder still(ResourceLocation still) {
            this.still = still;
            return this;
        }

        public Builder flowing(ResourceLocation flowing) {
            this.flowing = flowing;
            return this;
        }

        public Builder overlay(@Nullable ResourceLocation overlay) {
            this.overlay = overlay;
            return this;
        }

        public Builder camera(@Nullable ResourceLocation camera) {
            this.camera = camera;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder(FluidType fluid) {
            this.fluid = fluid;
        }
    }
}

