/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;

public record BlockPropertiesPredicate(Block block, List<Matcher> properties) implements BlockPredicate
{
    private static final Function<String, RuntimeException> JSON_EXCEPTION = JsonSyntaxException::new;
    private static final Function<String, RuntimeException> DECODER_EXCEPTION = DecoderException::new;
    public static final RecordLoadable<BlockPropertiesPredicate> LOADER = new RecordLoadable<BlockPropertiesPredicate>(){

        @Override
        public BlockPropertiesPredicate deserialize(JsonObject json, TypedMap context) {
            Block block = (Block)Loadables.BLOCK.getIfPresent(json, "block", context);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)json, (String)"properties").entrySet()) {
                Property<?> property = BlockPropertiesPredicate.parseProperty(block, (String)entry.getKey(), JSON_EXCEPTION);
                builder.add((Object)Matcher.deserialize(property, (JsonElement)entry.getValue()));
            }
            return new BlockPropertiesPredicate(block, (List<Matcher>)builder.build());
        }

        @Override
        public void serialize(BlockPropertiesPredicate object, JsonObject json) {
            json.add("block", Loadables.BLOCK.serialize(object.block));
            JsonObject properties = new JsonObject();
            for (Matcher matcher : object.properties) {
                properties.add(matcher.property().m_61708_(), matcher.serialize());
            }
            json.add("properties", (JsonElement)properties);
        }

        @Override
        public BlockPropertiesPredicate decode(FriendlyByteBuf buffer, TypedMap context) {
            Block block = (Block)Loadables.BLOCK.decode(buffer, context);
            int size = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)Matcher.fromNetwork(block, buffer));
            }
            return new BlockPropertiesPredicate(block, (List<Matcher>)builder.build());
        }

        @Override
        public void encode(FriendlyByteBuf buffer, BlockPropertiesPredicate object) {
            Loadables.BLOCK.encode(buffer, object.block);
            buffer.m_130130_(object.properties.size());
            for (Matcher matcher : object.properties) {
                matcher.toNetwork(buffer);
            }
        }
    };

    @Override
    public boolean matches(BlockState input) {
        if (input.m_60734_() != this.block) {
            return false;
        }
        for (Matcher matcher : this.properties) {
            if (matcher.matches(input)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RecordLoadable<BlockPropertiesPredicate> getLoader() {
        return LOADER;
    }

    private static Property<?> parseProperty(Block block, String name, Function<String, RuntimeException> exception) {
        Property property = block.m_49965_().m_61081_(name);
        if (property == null) {
            throw exception.apply("Property " + name + " does not exist in block " + BuiltInRegistries.f_256975_.m_7981_((Object)block));
        }
        return property;
    }

    public static Builder block(Block block) {
        return new Builder(block);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Matcher {
        public boolean matches(BlockState var1);

        public Property<?> property();

        public JsonElement serialize();

        public void toNetwork(FriendlyByteBuf var1);

        private static <T extends Comparable<T>> T parseValue(Property<T> property, String name, Function<String, RuntimeException> exception) {
            Optional value = property.m_6215_(name);
            if (value.isPresent()) {
                return (T)((Comparable)value.get());
            }
            throw exception.apply("Unknown property value " + name);
        }

        public static <T extends Comparable<T>> Matcher deserialize(Property<T> property, JsonElement element) {
            if (element.isJsonPrimitive()) {
                return new SetMatcher<T>(property, Matcher.parseValue(property, GsonHelper.m_13805_((JsonElement)element, (String)property.m_61708_()), JSON_EXCEPTION));
            }
            if (element.isJsonArray()) {
                return new SetMatcher<ImmutableSet>(property, ImmutableSet.copyOf(JsonHelper.parseList(element.getAsJsonArray(), property.m_61708_(), (e, key) -> Matcher.parseValue(property, GsonHelper.m_13805_((JsonElement)e, (String)key), JSON_EXCEPTION))));
            }
            if (element.isJsonObject()) {
                JsonObject json = element.getAsJsonObject();
                Object min = null;
                Object max = null;
                if (json.has("min")) {
                    min = Matcher.parseValue(property, GsonHelper.m_13906_((JsonObject)json, (String)"min"), JSON_EXCEPTION);
                }
                if (json.has("max")) {
                    max = Matcher.parseValue(property, GsonHelper.m_13906_((JsonObject)json, (String)"max"), JSON_EXCEPTION);
                }
                if (min == null) {
                    if (max == null) {
                        throw new JsonSyntaxException("Either min or max must be set for a range matcher");
                    }
                } else if (min.equals(max)) {
                    return new SetMatcher<Object>(property, min);
                }
                return new RangeMatcher<Object>((Property<Object>)property, min, max);
            }
            throw new JsonSyntaxException("Invalid matcher type " + GsonHelper.m_13883_((JsonElement)element));
        }

        public static Matcher fromNetwork(Block block, FriendlyByteBuf buffer) {
            Property<?> property = BlockPropertiesPredicate.parseProperty(block, buffer.m_130136_(Short.MAX_VALUE), DECODER_EXCEPTION);
            return Matcher.fromNetwork(property, buffer);
        }

        public static <T extends Comparable<T>> Matcher fromNetwork(Property<T> property, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            if (size == 0) {
                Object min = null;
                Object max = null;
                RangeType rangeType = (RangeType)buffer.m_130066_(RangeType.class);
                if (rangeType != RangeType.MAX) {
                    min = Matcher.parseValue(property, buffer.m_130136_(Short.MAX_VALUE), DECODER_EXCEPTION);
                }
                if (rangeType != RangeType.MIN) {
                    max = Matcher.parseValue(property, buffer.m_130136_(Short.MAX_VALUE), DECODER_EXCEPTION);
                }
                return new RangeMatcher<Object>((Property<Object>)property, min, max);
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < size; ++i) {
                builder.add(Matcher.parseValue(property, buffer.m_130136_(Short.MAX_VALUE), DECODER_EXCEPTION));
            }
            return new SetMatcher<ImmutableSet>(property, builder.build());
        }
    }

    public static class Builder {
        private final Block block;
        private final Map<Property<?>, Matcher> matchers = new LinkedHashMap();

        private Builder matches(Matcher matcher) {
            Property<?> property = matcher.property();
            if (!this.block.m_49965_().m_61092_().contains(property)) {
                throw new IllegalArgumentException("Property " + property + " does not exist in block " + this.block);
            }
            Matcher original = this.matchers.put(property, matcher);
            if (original != null) {
                throw new IllegalArgumentException("Matcher for property already exists: previous matcher " + original);
            }
            return this;
        }

        public <T extends Comparable<T>> Builder matches(Property<T> property, Set<T> values) {
            return this.matches(new SetMatcher<Set<T>>(property, values));
        }

        @SafeVarargs
        public final <T extends Comparable<T>> Builder matches(Property<T> property, T ... values) {
            return this.matches(property, Set.of(values));
        }

        public <T extends Comparable<T>> Builder range(Property<T> property, T min, T max) {
            if (Objects.equals(min, max)) {
                return this.matches(property, new Comparable[]{min});
            }
            return this.matches(new RangeMatcher<T>(property, min, max));
        }

        public <T extends Comparable<T>> Builder min(Property<T> property, T min) {
            return this.matches(new RangeMatcher<Object>((Property<Object>)property, min, null));
        }

        public <T extends Comparable<T>> Builder max(Property<T> property, T max) {
            return this.matches(new RangeMatcher<Object>((Property<Object>)property, null, max));
        }

        public BlockPropertiesPredicate build() {
            if (this.matchers.isEmpty()) {
                throw new IllegalArgumentException("Must have at least one property");
            }
            return new BlockPropertiesPredicate(this.block, (List<Matcher>)ImmutableList.copyOf(this.matchers.values()));
        }

        private Builder(Block block) {
            this.block = block;
        }
    }

    public record RangeMatcher<T extends Comparable<T>>(Property<T> property, @Nullable T min, @Nullable T max) implements Matcher
    {
        public RangeMatcher {
            RangeType.fromValues(min, max);
        }

        @Override
        public boolean matches(BlockState state) {
            Comparable value = state.m_61143_(this.property);
            return !(this.min != null && value.compareTo(this.min) < 0 || this.max != null && value.compareTo(this.max) > 0);
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            if (this.min != null) {
                json.addProperty("min", this.property.m_6940_(this.min));
            }
            if (this.max != null) {
                json.addProperty("max", this.property.m_6940_(this.max));
            }
            return json;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.property.m_61708_());
            buffer.m_130130_(0);
            buffer.m_130068_((Enum)RangeType.fromValues(this.min, this.max));
            if (this.min != null) {
                buffer.m_130070_(this.property.m_6940_(this.min));
            }
            if (this.max != null) {
                buffer.m_130070_(this.property.m_6940_(this.max));
            }
        }
    }

    private static enum RangeType {
        FULL,
        MIN,
        MAX;


        public static RangeType fromValues(@Nullable Object min, @Nullable Object max) {
            if (max == null) {
                if (min == null) {
                    throw new IllegalArgumentException("Cannot have both min and max null");
                }
                return MIN;
            }
            if (min == null) {
                return MAX;
            }
            return FULL;
        }
    }

    public record SetMatcher<T extends Comparable<T>>(Property<T> property, Set<T> values) implements Matcher
    {
        public SetMatcher {
            if (values.isEmpty()) {
                throw new IllegalArgumentException("Values must not be empty");
            }
        }

        public SetMatcher(Property<T> property, T value) {
            this((Property<Set<T>>)property, Set.of(value));
        }

        @Override
        public boolean matches(BlockState state) {
            return this.values.contains(state.m_61143_(this.property));
        }

        @Override
        public JsonElement serialize() {
            if (this.values.size() == 1) {
                return new JsonPrimitive(this.property.m_6940_((Comparable)this.values.iterator().next()));
            }
            JsonArray array = new JsonArray();
            for (Comparable value : this.values) {
                array.add(this.property.m_6940_(value));
            }
            return array;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.property.m_61708_());
            buffer.m_130130_(this.values.size());
            for (Comparable value : this.values) {
                buffer.m_130070_(this.property.m_6940_(value));
            }
        }
    }
}

