/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.registry;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.ResourceLocationLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public abstract class AbstractNamedComponentRegistry<T>
implements ResourceLocationLoadable<T> {
    protected final String errorText;

    public AbstractNamedComponentRegistry(String errorText) {
        this.errorText = errorText + " ";
    }

    @Nullable
    public abstract T getValue(ResourceLocation var1);

    public abstract Collection<ResourceLocation> getKeys();

    public abstract Collection<T> getValues();

    @Override
    public T fromKey(ResourceLocation name, String key) {
        T value = this.getValue(name);
        if (value != null) {
            return value;
        }
        throw new JsonSyntaxException(this.errorText + name + " at '" + key + "'");
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T value) {
        buffer.m_130085_(this.getKey(value));
    }

    public void encodeOptional(FriendlyByteBuf buffer, @Nullable T value) {
        if (value != null) {
            buffer.m_130070_(this.getKey(value).toString());
        } else {
            buffer.m_130070_("");
        }
    }

    private T decodeInternal(ResourceLocation name) {
        T value = this.getValue(name);
        if (value == null) {
            throw new DecoderException(this.errorText + name);
        }
        return value;
    }

    @Override
    public T decode(FriendlyByteBuf buffer, TypedMap context) {
        return this.decodeInternal(buffer.m_130281_());
    }

    @Nullable
    public T decodeOptional(FriendlyByteBuf buffer) {
        String key = buffer.m_130136_(Short.MAX_VALUE);
        if (key.isEmpty()) {
            return null;
        }
        return this.decodeInternal(new ResourceLocation(key));
    }

    @Override
    public <P> LoadableField<T, P> nullableField(String key, Function<P, T> getter) {
        return new NullableField<T, P>(this, key, getter);
    }

    private record NullableField<T, P>(AbstractNamedComponentRegistry<T> registry, String key, Function<P, T> getter) implements LoadableField<T, P>
    {
        @Override
        @Nullable
        public T get(JsonObject json, TypedMap context) {
            return this.registry.getOrDefault(json, this.key, null, context);
        }

        @Override
        public void serialize(P parent, JsonObject json) {
            T object = this.getter.apply(parent);
            if (object != null) {
                json.add(this.key, this.registry.serialize(object));
            }
        }

        @Override
        @Nullable
        public T decode(FriendlyByteBuf buffer, TypedMap context) {
            return this.registry.decodeOptional(buffer);
        }

        @Override
        public void encode(FriendlyByteBuf buffer, P parent) {
            this.registry.encodeOptional(buffer, this.getter.apply(parent));
        }
    }
}

