/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;

public class MantleItemLayerBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private final List<MantleItemLayerModel.LayerData> layers = new ArrayList<MantleItemLayerModel.LayerData>();

    protected MantleItemLayerBuilder(ResourceLocation loaderId, T parent, ExistingFileHelper existingFileHelper) {
        super(loaderId, parent, existingFileHelper);
    }

    public MantleItemLayerBuilder(T parent, ExistingFileHelper existingFileHelper) {
        this(Mantle.getResource("item_layer"), parent, existingFileHelper);
    }

    public MantleItemLayerBuilder<T> addLayer(MantleItemLayerModel.LayerData data) {
        this.layers.add(data);
        return this;
    }

    public MantleItemLayerBuilder<T> color(int color) {
        return this.addLayer(new MantleItemLayerModel.LayerData(color, 0, false, null));
    }

    public MantleItemLayerBuilder<T> luminosity(int luminosity) {
        return this.addLayer(new MantleItemLayerModel.LayerData(-1, luminosity, false, null));
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        if (!this.layers.isEmpty()) {
            JsonArray array = new JsonArray();
            for (MantleItemLayerModel.LayerData data : this.layers) {
                array.add((JsonElement)data.toJson());
            }
            json.add("layers", (JsonElement)array);
        }
        return json;
    }
}

