/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.IdAwareObject;

public class FluidObject<F extends Fluid>
implements Supplier<F>,
ItemLike,
IdAwareObject {
    @Nonnull
    protected final ResourceLocation id;
    @Nonnull
    private final TagKey<Fluid> forgeTag;
    private final Supplier<? extends FluidType> type;
    private final Supplier<? extends F> still;

    public FluidObject(ResourceLocation id, String tagName, Supplier<? extends FluidType> type, Supplier<? extends F> still) {
        this.id = id;
        this.forgeTag = FluidTags.create((ResourceLocation)new ResourceLocation("forge", tagName));
        this.type = type;
        this.still = still;
    }

    public FluidType getType() {
        return this.type.get();
    }

    @Override
    public F get() {
        return (F)Objects.requireNonNull((Fluid)this.still.get(), "Fluid object missing still fluid");
    }

    @Nullable
    public Item getBucket() {
        Item bucket = ((Fluid)this.still.get()).m_6859_();
        if (bucket == Items.f_41852_) {
            return null;
        }
        return bucket;
    }

    public Item m_5456_() {
        return ((Fluid)this.still.get()).m_6859_();
    }

    public FluidIngredient ingredient(int amount, boolean commonTag) {
        if (commonTag) {
            return FluidIngredient.of(this.get(), amount);
        }
        return FluidIngredient.of(this.getForgeTag(), amount);
    }

    @Override
    @Nonnull
    public ResourceLocation getId() {
        return this.id;
    }

    @Nonnull
    public TagKey<Fluid> getForgeTag() {
        return this.forgeTag;
    }
}

