/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.primitive;

import com.google.gson.JsonSyntaxException;
import java.util.Locale;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.mapping.EnumMapLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public record EnumLoadable<E extends Enum<E>>(Class<E> enumClass, E[] allowedValues) implements StringLoadable<E>
{
    public EnumLoadable(Class<E> enumClass) {
        this(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    @Override
    public E parseString(String name, String key) {
        for (E value : this.allowedValues) {
            if (!((Enum)value).name().toLowerCase(Locale.ROOT).equals(name)) continue;
            return value;
        }
        throw new JsonSyntaxException("Invalid " + this.enumClass.getSimpleName() + " " + name);
    }

    @Override
    public String getString(E object) {
        return ((Enum)object).name().toLowerCase(Locale.ROOT);
    }

    @Override
    public E decode(FriendlyByteBuf buffer, TypedMap context) {
        return (E)buffer.m_130066_(this.enumClass);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, E object) {
        buffer.m_130068_(object);
    }

    @Override
    public <V> Loadable<Map<E, V>> mapWithValues(Loadable<V> valueLoadable, int minSize) {
        return new EnumMapLoadable(this, valueLoadable, minSize);
    }
}

