/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.handler.codec.EncoderException;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.NBTLoadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public class ItemStackLoadable {
    private static final Function<ItemStack, Item> ITEM_GETTER = ItemStack::m_41720_;
    private static final BiFunction<ItemStack, ErrorFactory, ItemStack> NOT_EMPTY = (stack, error) -> {
        if (stack.m_41619_()) {
            throw error.create("ItemStack cannot be empty");
        }
        return stack;
    };
    private static final LoadableField<Item, ItemStack> ITEM = Loadables.ITEM.defaultField("item", Items.f_41852_, false, ITEM_GETTER);
    private static final LoadableField<Integer, ItemStack> COUNT = IntLoadable.FROM_ZERO.defaultField("count", 1, true, ItemStack::m_41613_);
    private static final LoadableField<CompoundTag, ItemStack> NBT = NBTLoadable.ALLOW_STRING.nullableField("nbt", ItemStack::m_41783_);
    public static final Loadable<ItemStack> OPTIONAL_ITEM = Loadables.ITEM.flatXmap(item -> ItemStackLoadable.makeStack(item, 1, null), ITEM_GETTER);
    public static final RecordLoadable<ItemStack> OPTIONAL_STACK = RecordLoadable.create(ITEM, COUNT, (item, count) -> ItemStackLoadable.makeStack(item, count, null)).compact(OPTIONAL_ITEM, stack -> stack.m_41613_() == 1);
    public static final RecordLoadable<ItemStack> OPTIONAL_ITEM_NBT = NBTStack.FIXED_COUNT;
    public static final RecordLoadable<ItemStack> OPTIONAL_STACK_NBT = NBTStack.READ_COUNT;
    public static final Loadable<ItemStack> REQUIRED_ITEM = ItemStackLoadable.notEmpty(OPTIONAL_ITEM);
    public static final RecordLoadable<ItemStack> REQUIRED_STACK = ItemStackLoadable.notEmpty(OPTIONAL_STACK);
    public static final RecordLoadable<ItemStack> REQUIRED_ITEM_NBT = ItemStackLoadable.notEmpty(OPTIONAL_ITEM_NBT);
    public static final RecordLoadable<ItemStack> REQUIRED_STACK_NBT = ItemStackLoadable.notEmpty(OPTIONAL_STACK_NBT);

    private ItemStackLoadable() {
    }

    private static ItemStack makeStack(Item item, int count, @Nullable CompoundTag nbt) {
        if (item == Items.f_41852_ || count == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (nbt != null) {
            stack.m_41751_(nbt);
        }
        return stack;
    }

    public static Loadable<ItemStack> notEmpty(Loadable<ItemStack> loadable) {
        return loadable.validate(NOT_EMPTY);
    }

    public static RecordLoadable<ItemStack> notEmpty(RecordLoadable<ItemStack> loadable) {
        return loadable.validate((BiFunction)NOT_EMPTY);
    }

    private static enum NBTStack implements RecordLoadable<ItemStack>
    {
        READ_COUNT,
        FIXED_COUNT;


        @Override
        public ItemStack deserialize(JsonObject json, TypedMap context) {
            int count = 1;
            if (this == READ_COUNT) {
                count = (Integer)COUNT.get(json, context);
            }
            return ItemStackLoadable.makeStack((Item)ITEM.get(json, context), count, (CompoundTag)NBT.get(json, context));
        }

        @Override
        public void serialize(ItemStack stack, JsonObject json) {
            ITEM.serialize(stack, json);
            if (this == READ_COUNT) {
                COUNT.serialize(stack, json);
            }
            NBT.serialize(stack, json);
        }

        @Override
        public ItemStack convert(JsonElement element, String key, TypedMap context) {
            if (element.isJsonPrimitive()) {
                return OPTIONAL_ITEM.convert(element, key, context);
            }
            return (ItemStack)RecordLoadable.super.convert(element, key, context);
        }

        @Override
        public JsonElement serialize(ItemStack stack) {
            if (!(this != FIXED_COUNT && stack.m_41613_() != 1 || stack.m_41782_())) {
                return OPTIONAL_ITEM.serialize(stack);
            }
            return RecordLoadable.super.serialize(stack);
        }

        @Override
        public ItemStack decode(FriendlyByteBuf buffer, TypedMap context) {
            Item item = (Item)ITEM.decode(buffer, context);
            int count = 1;
            if (this == READ_COUNT) {
                count = (Integer)COUNT.decode(buffer, context);
            }
            CompoundTag nbt = buffer.m_130260_();
            if (item == Items.f_41852_ || count <= 0) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = new ItemStack((ItemLike)item, count);
            stack.readShareTag(nbt);
            return stack;
        }

        @Override
        public void encode(FriendlyByteBuf buffer, ItemStack stack) throws EncoderException {
            ITEM.encode(buffer, stack);
            if (this == READ_COUNT) {
                COUNT.encode(buffer, stack);
            }
            buffer.m_130079_(stack.getShareTag());
        }
    }
}

