/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.field.AlwaysPresentLoadableField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public final class MergingRegistryField<T, P>
extends Record
implements AlwaysPresentLoadableField<T, P> {
    private final RecordLoadable<T> loadable;
    private final String typeKey;
    private final Function<P, T> getter;

    public MergingRegistryField(RecordLoadable<T> loadable, String typeKey, Function<P, T> getter) {
        this.loadable = loadable;
        this.typeKey = typeKey;
        this.getter = getter;
    }

    public static void mapType(JsonObject json, String typeKey) {
        json.addProperty("type", GsonHelper.m_13906_((JsonObject)json, (String)typeKey));
        json.remove(typeKey);
    }

    public static void serializeInto(JsonObject json, String typeKey, JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject nestedObject = element.getAsJsonObject();
            for (Map.Entry entry : nestedObject.entrySet()) {
                String key = (String)entry.getKey();
                if (typeKey.equals(key)) {
                    throw new JsonIOException("Unable to serialize nested object, object already has key " + typeKey);
                }
                if ("type".equals(key)) {
                    key = typeKey;
                }
                json.add(key, (JsonElement)entry.getValue());
            }
        } else if (element.isJsonPrimitive()) {
            json.add(typeKey, element);
        } else {
            throw new JsonIOException("Unable to serialize nested object, expected string or object");
        }
    }

    @Override
    public T get(JsonObject json) {
        MergingRegistryField.mapType(json, this.typeKey);
        return this.loadable.deserialize(json);
    }

    @Override
    public void serialize(P parent, JsonObject json) {
        MergingRegistryField.serializeInto(json, this.typeKey, this.loadable.serialize(this.getter.apply(parent)));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MergingRegistryField.class, "loadable;typeKey;getter", "loadable", "typeKey", "getter"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MergingRegistryField.class, "loadable;typeKey;getter", "loadable", "typeKey", "getter"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MergingRegistryField.class, "loadable;typeKey;getter", "loadable", "typeKey", "getter"}, this, o);
    }

    @Override
    public RecordLoadable<T> loadable() {
        return this.loadable;
    }

    public String typeKey() {
        return this.typeKey;
    }

    @Override
    public Function<P, T> getter() {
        return this.getter;
    }
}

