/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.IAmLoadable;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.FluidStackLoadable;
import slimeknights.mantle.data.loadable.mapping.EitherLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.RegistryHelper;

public abstract class FluidIngredient
implements IAmLoadable {
    public static final FluidMatch EMPTY = new FluidMatch(Fluids.f_76191_, 0);
    private static final Loadable<FluidIngredient> NETWORK = FluidStackLoadable.REQUIRED_STACK.list(0).flatXmap(fluids -> FluidIngredient.of(fluids.stream().map(FluidIngredient::of).toList()), FluidIngredient::getFluids);
    private static final RecordLoadable<FluidMatch> FLUID_MATCH = RecordLoadable.create(Loadables.FLUID.requiredField("fluid", i -> i.fluid), IntLoadable.FROM_ONE.requiredField("amount", i -> i.amount), FluidIngredient::of);
    @Deprecated(forRemoval=true)
    private static final RecordLoadable<FluidMatch> NAME_MATCH = RecordLoadable.create(Loadables.FLUID.requiredField("name", i -> i.fluid), IntLoadable.FROM_ONE.requiredField("amount", i -> i.amount), (fluid, amount) -> {
        Mantle.logger.warn("Using deprecated key 'name' for fluid ingredient, use 'fluid' instead. This will be removed in the future");
        return FluidIngredient.of(fluid, (int)amount);
    });
    private static final RecordLoadable<TagMatch> TAG_MATCH = RecordLoadable.create(Loadables.FLUID_TAG.requiredField("tag", i -> i.tag), IntLoadable.FROM_ONE.requiredField("amount", i -> i.amount), FluidIngredient::of);
    private static final Loadable<Compound> COMPOUND = FluidIngredient.loadableBuilder().build(NETWORK).list(2).flatXmap(Compound::new, c -> c.ingredients);
    public static final Loadable<FluidIngredient> LOADABLE = FluidIngredient.loadableBuilder().array(COMPOUND).build(NETWORK);
    private List<FluidStack> displayFluids;

    private static EitherLoadable.TypedBuilder<FluidIngredient> loadableBuilder() {
        return EitherLoadable.typed().key("fluid", FLUID_MATCH).key("tag", TAG_MATCH).key("name", NAME_MATCH);
    }

    public static FluidMatch of(Fluid fluid, int amount) {
        if (fluid == Fluids.f_76191_ || amount <= 0) {
            return EMPTY;
        }
        return new FluidMatch(fluid, amount);
    }

    public static FluidIngredient of(FluidStack stack) {
        return FluidIngredient.of(stack.getFluid(), stack.getAmount());
    }

    public static TagMatch of(TagKey<Fluid> fluid, int amount) {
        return new TagMatch(fluid, amount);
    }

    public static FluidIngredient of(FluidIngredient ... ingredients) {
        return FluidIngredient.of(List.of(ingredients));
    }

    public static FluidIngredient of(List<FluidIngredient> ingredients) {
        if (ingredients.size() == 1) {
            return ingredients.get(0);
        }
        return new Compound(ingredients);
    }

    public abstract boolean test(Fluid var1);

    public abstract int getAmount(Fluid var1);

    public boolean test(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        return stack.getAmount() >= this.getAmount(fluid) && this.test(stack.getFluid());
    }

    public List<FluidStack> getFluids() {
        if (this.displayFluids == null) {
            this.displayFluids = this.getAllFluids().stream().filter(stack -> {
                Fluid fluid = stack.getFluid();
                return fluid.m_7444_(fluid.m_76145_());
            }).collect(Collectors.toList());
        }
        return this.displayFluids;
    }

    protected abstract List<FluidStack> getAllFluids();

    public JsonElement serialize() {
        return LOADABLE.serialize(this);
    }

    public static FluidIngredient deserialize(JsonObject parent, String key) {
        return LOADABLE.getIfPresent(parent, key);
    }

    @Deprecated
    public static FluidIngredient deserialize(JsonElement element, String key) {
        return LOADABLE.convert(element, key);
    }

    public void write(FriendlyByteBuf buffer) {
        NETWORK.encode(buffer, this);
    }

    public static FluidIngredient read(FriendlyByteBuf buffer) {
        return (FluidIngredient)NETWORK.decode(buffer);
    }

    private static class FluidMatch
    extends FluidIngredient {
        private final Fluid fluid;
        private final int amount;

        @Override
        public Loadable<?> loadable() {
            return FLUID_MATCH;
        }

        @Override
        public boolean test(Fluid fluid) {
            return fluid == this.fluid;
        }

        @Override
        public int getAmount(Fluid fluid) {
            return this.amount;
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return Collections.singletonList(new FluidStack(this.fluid, this.amount));
        }

        private FluidMatch(Fluid fluid, int amount) {
            this.fluid = fluid;
            this.amount = amount;
        }
    }

    private static class TagMatch
    extends FluidIngredient {
        private final TagKey<Fluid> tag;
        private final int amount;

        @Override
        public Loadable<?> loadable() {
            return TAG_MATCH;
        }

        @Override
        public boolean test(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        @Override
        public int getAmount(Fluid fluid) {
            return this.amount;
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return RegistryHelper.getTagValueStream(BuiltInRegistries.f_257020_, this.tag).map(fluid -> new FluidStack(fluid, this.amount)).toList();
        }

        public TagMatch(TagKey<Fluid> tag, int amount) {
            this.tag = tag;
            this.amount = amount;
        }
    }

    private static class Compound
    extends FluidIngredient {
        private final List<FluidIngredient> ingredients;

        @Override
        public Loadable<?> loadable() {
            return COMPOUND;
        }

        @Override
        public boolean test(Fluid fluid) {
            for (FluidIngredient ingredient : this.ingredients) {
                if (!ingredient.test(fluid)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean test(FluidStack stack) {
            for (FluidIngredient ingredient : this.ingredients) {
                if (!ingredient.test(stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getAmount(Fluid fluid) {
            for (FluidIngredient ingredient : this.ingredients) {
                if (!ingredient.test(fluid)) continue;
                return ingredient.getAmount(fluid);
            }
            return 0;
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return this.ingredients.stream().flatMap(ingredient -> ingredient.getFluids().stream()).collect(Collectors.toList());
        }

        public Compound(List<FluidIngredient> ingredients) {
            this.ingredients = ingredients;
        }
    }
}

