/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate;

import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.TagPredicateRegistry;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;

public class RegistryPredicateRegistry<R, T>
extends TagPredicateRegistry<R, T> {
    private final Function<T, R> getter;
    private final RecordLoadable<SetPredicate> setLoader;

    public RegistryPredicateRegistry(String name, IJsonPredicate<T> defaultInstance, Loadable<R> registry, Function<T, R> getter, String setKey, Loadable<TagKey<R>> tagKey, BiPredicate<TagKey<R>, T> tagMatcher) {
        super(name, defaultInstance, tagKey, tagMatcher);
        this.getter = getter;
        this.setLoader = RecordLoadable.create(registry.set().requiredField(setKey, p -> p.set), x$0 -> new SetPredicate(x$0));
        this.register(Mantle.getResource("set"), this.setLoader);
    }

    public IJsonPredicate<T> setOf(Set<R> values) {
        return new SetPredicate(values);
    }

    private class SetPredicate
    implements IJsonPredicate<T> {
        private final Set<R> set;

        @Override
        public boolean matches(T input) {
            return this.set.contains(RegistryPredicateRegistry.this.getter.apply(input));
        }

        @Override
        public IJsonPredicate<T> inverted() {
            return RegistryPredicateRegistry.this.invert(this);
        }

        @Override
        public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<T>> getLoader() {
            return RegistryPredicateRegistry.this.setLoader;
        }

        public SetPredicate(Set<R> set) {
            this.set = set;
        }
    }
}

