/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.adapter;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.item.BurnableBlockItem;
import slimeknights.mantle.item.BurnableSignItem;
import slimeknights.mantle.item.BurnableTallBlockItem;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.adapter.EnumRegistryAdapter;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;

public class ItemRegistryAdapter
extends EnumRegistryAdapter<Item> {
    private final Item.Properties defaultProps;

    public ItemRegistryAdapter(IForgeRegistry<Item> registry) {
        this(registry, (Item.Properties)null);
    }

    public ItemRegistryAdapter(IForgeRegistry<Item> registry, @Nullable Item.Properties defaultProps) {
        super(registry);
        this.defaultProps = Objects.requireNonNullElseGet(defaultProps, Item.Properties::new);
    }

    public ItemRegistryAdapter(IForgeRegistry<Item> registry, String modid, @Nullable Item.Properties defaultProps) {
        super(registry, modid);
        this.defaultProps = Objects.requireNonNullElseGet(defaultProps, Item.Properties::new);
    }

    public TooltipItem registerDefault(String name) {
        return this.register(this.defaultProps, name);
    }

    @Override
    public TooltipItem register(Item.Properties props, String name) {
        return this.register(new TooltipItem(props), name);
    }

    public <T extends Item> T registerDefault(Function<Item.Properties, T> constructor, String name) {
        return (T)this.register((Item)constructor.apply(this.defaultProps), name);
    }

    @Override
    protected <I extends BlockItem> I register(I entry, Block name) {
        return this.register(entry, Objects.requireNonNull(BuiltInRegistries.f_256975_.m_7981_((Object)name)));
    }

    public BlockItem registerDefaultBlockItem(Block block) {
        return this.registerBlockItem(block, this.defaultProps);
    }

    public <T extends BlockItem> T registerBlockItem(Block block, BiFunction<Block, Item.Properties, T> constructor) {
        return (T)this.register((BlockItem)constructor.apply(block, this.defaultProps), block);
    }

    public BlockItem registerBlockItem(Block block, Item.Properties props) {
        return this.register((BlockItem)new BlockTooltipItem(block, props), block);
    }

    public <T extends BlockItem> T registerBlockItem(T blockItem) {
        return this.register(blockItem, blockItem.m_40614_());
    }

    public void registerDefaultBlockItem(BuildingBlockObject object) {
        this.registerDefaultBlockItem((Block)object.get());
        this.registerDefaultBlockItem((Block)object.getSlab());
        this.registerDefaultBlockItem((Block)object.getStairs());
    }

    public void registerDefaultBlockItem(WallBuildingBlockObject object) {
        this.registerDefaultBlockItem((BuildingBlockObject)object);
        this.registerDefaultBlockItem((Block)object.getWall());
    }

    public void registerDefaultBlockItem(FenceBuildingBlockObject object) {
        this.registerDefaultBlockItem((BuildingBlockObject)object);
        this.registerDefaultBlockItem((Block)object.getFence());
    }

    public void registerDefaultBlockItem(WoodBlockObject object, boolean isBurnable) {
        PropertyDispatch.TriFunction burnableSignItem;
        Function<Block, BlockItem> burnableTallItem;
        BiFunction<Block, Integer, BlockItem> burnableItem;
        if (isBurnable) {
            burnableItem = (block, burnTime) -> new BurnableBlockItem((Block)block, this.defaultProps, (int)burnTime);
            burnableTallItem = block -> new BurnableTallBlockItem((Block)block, this.defaultProps, 200);
            burnableSignItem = (props, standing, wall) -> new BurnableSignItem((Item.Properties)props, (Block)standing, (Block)wall, 200);
        } else {
            burnableItem = (block, burnTime) -> new BlockItem(block, this.defaultProps);
            burnableTallItem = block -> new DoubleHighBlockItem(block, this.defaultProps);
            burnableSignItem = SignItem::new;
        }
        BlockItem planks = this.registerBlockItem(burnableItem.apply((Block)object.get(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getSlab(), 150));
        this.registerBlockItem(burnableItem.apply((Block)object.getStairs(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getFence(), 300));
        this.registerBlockItem(burnableItem.apply(object.getLog(), 300));
        this.registerBlockItem(burnableItem.apply(object.getWood(), 300));
        this.registerBlockItem(burnableItem.apply(object.getStrippedLog(), 300));
        this.registerBlockItem(burnableItem.apply(object.getStrippedWood(), 300));
        this.registerBlockItem(burnableTallItem.apply((Block)object.getDoor()));
        this.registerBlockItem(burnableItem.apply((Block)object.getTrapdoor(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getFenceGate(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getPressurePlate(), 300));
        this.registerBlockItem(burnableItem.apply((Block)object.getButton(), 100));
        this.registerBlockItem((BlockItem)burnableSignItem.m_125475_((Object)new Item.Properties().m_41487_(16), (Object)object.getSign(), (Object)object.getWallSign()));
    }

    public void registerDefaultBlockItem(EnumObject<?, ? extends Block> enumObject) {
        enumObject.values().forEach(this::registerDefaultBlockItem);
    }

    public <B extends Block> void registerBlockItem(EnumObject<?, B> enumObject, Item.Properties props) {
        enumObject.values().forEach(block -> this.registerBlockItem((Block)block, props));
    }

    public <B extends Block> void registerBlockItem(EnumObject<?, B> enumObject, Function<B, ? extends BlockItem> blockItem) {
        enumObject.values().forEach(block -> this.registerBlockItem((BlockItem)blockItem.apply(block)));
    }

    public BucketItem registerBucket(Supplier<? extends Fluid> fluid, String baseName) {
        return this.register(new BucketItem(fluid, RegistrationHelper.BUCKET_PROPS), baseName + "_bucket");
    }

    public SpawnEggItem registerSpawnEgg(Supplier<? extends EntityType<? extends Mob>> type, int primary, int secondary, String baseName) {
        return (SpawnEggItem)this.register(new ForgeSpawnEggItem(type, primary, secondary, new Item.Properties()), baseName + "_spawn_egg");
    }
}

