/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import org.joml.Vector3f;

public class ModelHelper {
    private static final Map<Block, ResourceLocation> TEXTURE_NAME_CACHE = new ConcurrentHashMap<Block, ResourceLocation>();
    public static final ResourceManagerReloadListener LISTENER = manager -> TEXTURE_NAME_CACHE.clear();

    private static ResourceLocation getParticleTextureInternal(Block block) {
        TextureAtlasSprite particle = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(block.m_49966_()).m_6160_();
        if (particle != null) {
            return particle.m_245424_().m_246162_();
        }
        return MissingTextureAtlasSprite.m_118071_();
    }

    public static ResourceLocation getParticleTexture(Block block) {
        return TEXTURE_NAME_CACHE.computeIfAbsent(block, ModelHelper::getParticleTextureInternal);
    }

    public static <T> T arrayToObject(JsonObject json, String name, int size, Function<float[], T> mapper) {
        JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)name);
        if (array.size() != size) {
            throw new JsonParseException("Expected " + size + " " + name + " values, found: " + array.size());
        }
        float[] vec = new float[size];
        for (int i = 0; i < size; ++i) {
            vec[i] = GsonHelper.m_13888_((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return mapper.apply(vec);
    }

    public static Vector3f arrayToVector(JsonObject json, String name) {
        return ModelHelper.arrayToObject(json, name, 3, arr -> new Vector3f(arr[0], arr[1], arr[2]));
    }

    public static JsonArray vectorToJson(Vector3f vector) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(vector.x()));
        array.add((Number)Float.valueOf(vector.y()));
        array.add((Number)Float.valueOf(vector.z()));
        return array;
    }

    public static boolean checkRotation(float rotation) {
        return rotation >= 0.0f && rotation % 90.0f == 0.0f && rotation <= 270.0f;
    }

    public static int getRotation(JsonObject json, String key) {
        int i = GsonHelper.m_13824_((JsonObject)json, (String)key, (int)0);
        if (ModelHelper.checkRotation(i)) {
            return i;
        }
        throw new JsonParseException("Invalid '" + key + "' " + i + " found, only 0/90/180/270 allowed");
    }

    private ModelHelper() {
    }
}

