/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.common.NBTLoadable;
import slimeknights.mantle.recipe.helper.ItemOutput;

public class ItemNameOutput
extends ItemOutput {
    private final ResourceLocation name;
    private final int count;
    @Nullable
    private final CompoundTag nbt;

    public static ItemNameOutput fromName(ResourceLocation name, int count) {
        return ItemNameOutput.fromName(name, count, null);
    }

    public static ItemNameOutput fromName(ResourceLocation name) {
        return ItemNameOutput.fromName(name, 1);
    }

    @Override
    public ItemStack get() {
        throw new UnsupportedOperationException("Cannot get the item stack from a item name output");
    }

    @Override
    public JsonElement serialize(boolean writeCount) {
        String itemName = this.name.toString();
        if (!(this.nbt != null || this.count > 1 && writeCount)) {
            return new JsonPrimitive(itemName);
        }
        JsonObject jsonResult = new JsonObject();
        jsonResult.addProperty("item", itemName);
        if (writeCount) {
            jsonResult.addProperty("count", (Number)this.count);
        }
        if (this.nbt != null) {
            jsonResult.add("nbt", (JsonElement)NBTLoadable.ALLOW_STRING.serialize(this.nbt));
        }
        return jsonResult;
    }

    private ItemNameOutput(ResourceLocation name, int count, @Nullable CompoundTag nbt) {
        this.name = name;
        this.count = count;
        this.nbt = nbt;
    }

    public static ItemNameOutput fromName(ResourceLocation name, int count, @Nullable CompoundTag nbt) {
        return new ItemNameOutput(name, count, nbt);
    }
}

