/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.command.client.MantleClientCommand;

public class BookCommand {
    private static final String BOOK_NOT_FOUND = "command.mantle.book_test.not_found";
    private static final String EXPORT_SUCCESS = "command.mantle.book.export.success";
    private static final String EXPORT_FAIL = "command.mantle.book.export.error_generic";
    private static final String EXPORT_FAIL_IO = "command.mantle.book.export.error_io";

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(source -> source.m_6761_(2) && source.m_81373_() instanceof AbstractClientPlayer)).then(Commands.m_82127_((String)"open").then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MantleClientCommand.REGISTERED_BOOKS).executes(BookCommand::openBook)))).then(Commands.m_82127_((String)"export_images").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MantleClientCommand.REGISTERED_BOOKS).then(Commands.m_82129_((String)"scale", (ArgumentType)IntegerArgumentType.integer((int)1, (int)16)).executes(BookCommand::exportImagesWithScale))).executes(BookCommand::exportImages)));
    }

    private static int openBook(CommandContext<CommandSourceStack> context) {
        ResourceLocation book = ResourceLocationArgument.m_107011_(context, (String)"id");
        BookData bookData = BookLoader.getBook(book);
        if (bookData == null) {
            BookCommand.bookNotFound(book);
            return 1;
        }
        Minecraft.m_91087_().m_6937_(() -> bookData.openGui((Component)Component.m_237113_((String)"Book"), "", null, null));
        return 0;
    }

    private static int exportImagesWithScale(CommandContext<CommandSourceStack> context) {
        ResourceLocation book = ResourceLocationArgument.m_107011_(context, (String)"id");
        int scale = (Integer)context.getArgument("scale", Integer.class);
        return BookCommand.doExportImages(book, scale);
    }

    private static int exportImages(CommandContext<CommandSourceStack> context) {
        ResourceLocation book = ResourceLocationArgument.m_107011_(context, (String)"id");
        return BookCommand.doExportImages(book, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doExportImages(ResourceLocation book, int scale) {
        BookData bookData = BookLoader.getBook(book);
        Path gameDirectory = Minecraft.m_91087_().f_91069_.toPath();
        Path screenshotDir = Paths.get(gameDirectory.toString(), "screenshots", "mantle_book", book.m_135827_(), book.m_135815_());
        if (bookData != null) {
            if (!screenshotDir.toFile().mkdirs() && !screenshotDir.toFile().exists()) {
                throw new CommandRuntimeException((Component)Component.m_237115_((String)EXPORT_FAIL_IO));
            }
            int width = 412 * scale;
            int height = 200 * scale;
            float zFar = 31000.0f;
            bookData.load();
            BookScreen screen = new BookScreen((Component)Component.m_237113_((String)"Book"), bookData, "", null, null);
            screen.m_6575_(Minecraft.m_91087_(), width / scale, height / scale);
            screen.drawArrows = false;
            screen.mouseInput = false;
            Matrix4f matrix = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, zFar);
            RenderSystem.setProjectionMatrix((Matrix4f)matrix, (VertexSorting)VertexSorting.f_276633_);
            PoseStack stack = RenderSystem.getModelViewStack();
            stack.m_85836_();
            stack.m_166856_();
            stack.m_252880_(0.0f, 0.0f, 1000.0f - zFar);
            stack.m_85841_((float)scale, (float)scale, 1.0f);
            RenderSystem.applyModelViewMatrix();
            Lighting.m_84931_();
            TextureTarget target = new TextureTarget(width, height, true, Minecraft.f_91002_);
            target.enableStencil();
            try {
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(2048));
                target.m_83947_(true);
                GuiGraphics gui = new GuiGraphics(Minecraft.m_91087_(), buffer);
                do {
                    RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
                    screen.m_86600_();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    gui.m_280168_().m_85836_();
                    screen.m_88315_(gui, 0, 0, 0.0f);
                    gui.m_280262_();
                    gui.m_280168_().m_85849_();
                    try (NativeImage image = BookCommand.takeScreenshot((RenderTarget)target);){
                        int page = screen.getPage_();
                        Object pageFormat = page < 0 ? "cover" : "page_" + page;
                        Path path = Paths.get(screenshotDir.toString(), (String)pageFormat + ".png");
                        if (page == -1) {
                            try (NativeImage scaled = new NativeImage(image.m_85102_(), width / 2, height, false);){
                                image.m_260930_(scaled, image.m_84982_() / 2 - width / 4, 0, 0, 0, width / 2, height, false, false);
                                scaled.m_85066_(path);
                                continue;
                            }
                            catch (Exception e) {
                                Mantle.logger.error("Failed to save screenshot", (Throwable)e);
                                throw new CommandRuntimeException((Component)Component.m_237115_((String)EXPORT_FAIL));
                            }
                        }
                        image.m_85066_(path);
                    }
                    catch (Exception e) {
                        Mantle.logger.error("Failed to save screenshot", (Throwable)e);
                        throw new CommandRuntimeException((Component)Component.m_237115_((String)EXPORT_FAIL));
                    }
                } while (screen.nextPage());
            }
            finally {
                stack.m_85849_();
                RenderSystem.applyModelViewMatrix();
                RenderSystem.defaultBlendFunc();
                target.m_83970_();
                target.m_83930_();
            }
        }
        BookCommand.bookNotFound(book);
        return 1;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            MutableComponent fileComponent = Component.m_237113_((String)screenshotDir.toString()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, screenshotDir.toAbsolutePath().toString())));
            player.m_5661_((Component)Component.m_237110_((String)EXPORT_SUCCESS, (Object[])new Object[]{fileComponent}), false);
        }
        return 0;
    }

    private static NativeImage takeScreenshot(RenderTarget pFramebuffer) {
        int i = pFramebuffer.f_83915_;
        int j = pFramebuffer.f_83916_;
        NativeImage nativeimage = new NativeImage(i, j, false);
        RenderSystem.bindTexture((int)pFramebuffer.m_83975_());
        nativeimage.m_85045_(0, false);
        nativeimage.m_85122_();
        return nativeimage;
    }

    public static void bookNotFound(ResourceLocation book) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_5661_((Component)Component.m_237110_((String)BOOK_NOT_FOUND, (Object[])new Object[]{book}).m_130940_(ChatFormatting.RED), false);
        }
    }
}

