/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public class MappedLoadable<F, T>
implements Loadable<T> {
    private final Loadable<F> base;
    protected final BiFunction<F, ErrorFactory, T> from;
    protected final BiFunction<T, ErrorFactory, F> to;

    public static <T, F> Loadable<T> of(Loadable<F> base, BiFunction<F, ErrorFactory, T> from, BiFunction<T, ErrorFactory, F> to) {
        return new MappedLoadable<F, T>(base, from, to);
    }

    public static <T, F> RecordLoadable<T> of(RecordLoadable<F> base, BiFunction<F, ErrorFactory, T> from, BiFunction<T, ErrorFactory, F> to) {
        return new Record<F, T>(base, from, to);
    }

    public static <T, F> StringLoadable<T> of(StringLoadable<F> base, BiFunction<F, ErrorFactory, T> from, BiFunction<T, ErrorFactory, F> to) {
        return new StringMapped<F, T>(base, from, to);
    }

    public static <T, R> BiFunction<T, ErrorFactory, R> flatten(Function<T, R> function) {
        return (value, error) -> function.apply(value);
    }

    @Override
    public T convert(JsonElement element, String key) {
        return this.from.apply(this.base.convert(element, key), ErrorFactory.JSON_SYNTAX_ERROR);
    }

    @Override
    public JsonElement serialize(T object) {
        return this.base.serialize(this.to.apply(object, ErrorFactory.RUNTIME));
    }

    @Override
    public T decode(FriendlyByteBuf buffer) {
        return this.from.apply(this.base.decode(buffer), ErrorFactory.DECODER_EXCEPTION);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T object) {
        this.base.encode(buffer, this.to.apply(object, ErrorFactory.ENCODER_EXCEPTION));
    }

    protected MappedLoadable(Loadable<F> base, BiFunction<F, ErrorFactory, T> from, BiFunction<T, ErrorFactory, F> to) {
        this.base = base;
        this.from = from;
        this.to = to;
    }

    private static class Record<F, T>
    extends MappedLoadable<F, T>
    implements RecordLoadable<T> {
        private final RecordLoadable<F> base;

        protected Record(RecordLoadable<F> base, BiFunction<F, ErrorFactory, T> from, BiFunction<T, ErrorFactory, F> to) {
            super(base, from, to);
            this.base = base;
        }

        @Override
        public T deserialize(JsonObject json, TypedMap context) {
            return (T)this.from.apply(this.base.deserialize(json, context), ErrorFactory.JSON_SYNTAX_ERROR);
        }

        @Override
        public void serialize(T object, JsonObject json) {
            this.base.serialize(this.to.apply(object, ErrorFactory.RUNTIME), json);
        }

        @Override
        public T decode(FriendlyByteBuf buffer, TypedMap context) {
            return (T)this.from.apply(this.base.decode(buffer, context), ErrorFactory.DECODER_EXCEPTION);
        }
    }

    private static class StringMapped<F, T>
    extends MappedLoadable<F, T>
    implements StringLoadable<T> {
        private final StringLoadable<F> base;

        protected StringMapped(StringLoadable<F> base, BiFunction<F, ErrorFactory, T> from, BiFunction<T, ErrorFactory, F> to) {
            super(base, from, to);
            this.base = base;
        }

        @Override
        public T parseString(String value, String key) {
            return (T)this.from.apply(this.base.parseString(value, key), ErrorFactory.JSON_SYNTAX_ERROR);
        }

        @Override
        public String getString(T object) {
            return this.base.getString(this.to.apply(object, ErrorFactory.RUNTIME));
        }
    }
}

