/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public final class RetexturedHelper {
    public static final String TAG_TEXTURE = "texture";
    public static final ModelProperty<Block> BLOCK_PROPERTY = new ModelProperty(block -> block != Blocks.f_50016_);

    public static String getTextureName(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return "";
        }
        return nbt.m_128461_(TAG_TEXTURE);
    }

    public static String getTextureName(ItemStack stack) {
        return RetexturedHelper.getTextureName(stack.m_41783_());
    }

    public static String getTextureName(Block block) {
        if (block == Blocks.f_50016_) {
            return "";
        }
        return Objects.requireNonNull(BuiltInRegistries.f_256975_.m_7981_((Object)block)).toString();
    }

    public static Block getBlock(String name) {
        ResourceLocation location;
        if (!name.isEmpty() && (location = ResourceLocation.m_135820_((String)name)) != null) {
            return (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(name));
        }
        return Blocks.f_50016_;
    }

    public static Block getTexture(ItemStack stack) {
        return RetexturedHelper.getBlock(RetexturedHelper.getTextureName(stack));
    }

    public static void setTexture(@Nullable CompoundTag nbt, String texture) {
        if (nbt != null) {
            if (texture.isEmpty()) {
                nbt.m_128473_(TAG_TEXTURE);
            } else {
                nbt.m_128359_(TAG_TEXTURE, texture);
            }
        }
    }

    public static ItemStack setTexture(ItemStack stack, String name) {
        if (!name.isEmpty()) {
            RetexturedHelper.setTexture(stack.m_41784_(), name);
        } else if (stack.m_41782_()) {
            RetexturedHelper.setTexture(stack.m_41783_(), name);
        }
        return stack;
    }

    public static ItemStack setTexture(ItemStack stack, @Nullable Block block) {
        if (block == null || block == Blocks.f_50016_) {
            return RetexturedHelper.setTexture(stack, "");
        }
        return RetexturedHelper.setTexture(stack, BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
    }

    public static void onTextureUpdated(BlockEntity self) {
        Level level = self.m_58904_();
        if (level != null && level.f_46443_) {
            self.requestModelDataUpdate();
            BlockState state = self.m_58900_();
            level.m_7260_(self.m_58899_(), state, state, 0);
        }
    }

    public static ModelData.Builder getModelDataBuilder(Block block) {
        if (block == Blocks.f_50016_) {
            block = null;
        }
        return ModelData.builder().with(BLOCK_PROPERTY, (Object)block);
    }

    public static ModelData getModelData(Block block) {
        return RetexturedHelper.getModelDataBuilder(block).build();
    }

    public static void addTooltip(ItemStack stack, List<Component> tooltip) {
        Block block = RetexturedHelper.getTexture(stack);
        if (block != Blocks.f_50016_) {
            tooltip.add((Component)block.m_49954_());
        }
    }

    public static boolean addTagVariants(CreativeModeTab.Output tab, ItemLike block, TagKey<Item> tag, CreativeModeTab.TabVisibility firstVisibility, @Nullable CreativeModeTab.TabVisibility variantVisibility) {
        boolean added = false;
        for (Holder candidate : BuiltInRegistries.f_257033_.m_206058_(tag)) {
            Item item;
            CreativeModeTab.TabVisibility visibility;
            CreativeModeTab.TabVisibility tabVisibility = visibility = added ? variantVisibility : firstVisibility;
            if (visibility == null) break;
            if (!candidate.m_203633_() || (item = (Item)candidate.m_203334_()) == block.m_5456_() || !(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            added = true;
            tab.m_246267_(RetexturedHelper.setTexture(new ItemStack(block), blockItem.m_40614_()), visibility);
        }
        return added;
    }

    private RetexturedHelper() {
    }
}

