/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.common.Tags;
import slimeknights.mantle.recipe.data.IRecipeHelper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;

public interface ICommonRecipeHelper
extends IRecipeHelper {
    default public void packingRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, String largeName, ItemLike large, String smallName, ItemLike small, String folder) {
        ResourceLocation largeId = this.id(large);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)large).m_126127_(Character.valueOf('#'), small).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)small)).m_126145_(largeId.toString()).m_126140_(consumer, this.wrap(largeId, folder, String.format("_from_%ss", smallName)));
        ResourceLocation smallId = this.id(small);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)small, (int)9).m_126209_(large).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)large)).m_126145_(smallId.toString()).m_126140_(consumer, this.wrap(smallId, folder, String.format("_from_%s", largeName)));
    }

    default public void packingRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, String largeName, ItemLike largeItem, String smallName, ItemLike smallItem, TagKey<Item> smallTag, String folder) {
        ResourceLocation largeId = this.id(largeItem);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)largeItem).m_206416_(Character.valueOf('#'), smallTag).m_126127_(Character.valueOf('*'), smallItem).m_126130_("###").m_126130_("#*#").m_126130_("###").m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)smallItem)).m_126145_(largeId.toString()).m_126140_(consumer, this.wrap(largeId, folder, String.format("_from_%ss", smallName)));
        ResourceLocation smallId = this.id(smallItem);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)smallItem, (int)9).m_126209_(largeItem).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)largeItem)).m_126145_(smallId.toString()).m_126140_(consumer, this.wrap(smallId, folder, String.format("_from_%s", largeName)));
    }

    default public void metalCrafting(Consumer<FinishedRecipe> consumer, MetalItemObject metal, String folder) {
        Item ingot = metal.getIngot();
        this.packingRecipe(consumer, RecipeCategory.MISC, "block", (ItemLike)metal.get(), "ingot", (ItemLike)ingot, metal.getIngotTag(), folder);
        this.packingRecipe(consumer, RecipeCategory.MISC, "ingot", (ItemLike)ingot, "nugget", (ItemLike)metal.getNugget(), metal.getNuggetTag(), folder);
    }

    default public void slabStairsCrafting(Consumer<FinishedRecipe> consumer, BuildingBlockObject building, String folder, boolean addStonecutter) {
        Item item = building.m_5456_();
        ResourceLocation itemId = this.id((ItemLike)item);
        InventoryChangeTrigger.TriggerInstance hasBlock = RecipeProvider.m_125977_((ItemLike)item);
        SlabBlock slab = building.getSlab();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)6).m_126127_(Character.valueOf('B'), (ItemLike)item).m_126130_("BBB").m_126132_("has_item", (CriterionTriggerInstance)hasBlock).m_126145_(this.id((ItemLike)slab).toString()).m_126140_(consumer, this.wrap(itemId, folder, "_slab"));
        StairBlock stairs = building.getStairs();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).m_126127_(Character.valueOf('B'), (ItemLike)item).m_126130_("B  ").m_126130_("BB ").m_126130_("BBB").m_126132_("has_item", (CriterionTriggerInstance)hasBlock).m_126145_(this.id((ItemLike)stairs).toString()).m_126140_(consumer, this.wrap(itemId, folder, "_stairs"));
        if (addStonecutter) {
            Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
            SingleItemRecipeBuilder.m_246944_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)2).m_126132_("has_item", (CriterionTriggerInstance)hasBlock).m_126140_(consumer, this.wrap(itemId, folder, "_slab_stonecutter"));
            SingleItemRecipeBuilder.m_245264_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs).m_126132_("has_item", (CriterionTriggerInstance)hasBlock).m_126140_(consumer, this.wrap(itemId, folder, "_stairs_stonecutter"));
        }
    }

    default public void stairSlabWallCrafting(Consumer<FinishedRecipe> consumer, WallBuildingBlockObject building, String folder, boolean addStonecutter) {
        this.slabStairsCrafting(consumer, building, folder, addStonecutter);
        Item item = building.m_5456_();
        ResourceLocation itemId = this.id((ItemLike)item);
        InventoryChangeTrigger.TriggerInstance hasBlock = RecipeProvider.m_125977_((ItemLike)item);
        WallBlock wall = building.getWall();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (int)6).m_126127_(Character.valueOf('B'), (ItemLike)item).m_126130_("BBB").m_126130_("BBB").m_126132_("has_item", (CriterionTriggerInstance)hasBlock).m_126145_(this.id((ItemLike)wall).toString()).m_126140_(consumer, this.wrap(itemId, folder, "_wall"));
        if (addStonecutter) {
            Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
            SingleItemRecipeBuilder.m_245264_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall).m_126132_("has_item", (CriterionTriggerInstance)hasBlock).m_126140_(consumer, this.wrap(itemId, folder, "_wall_stonecutter"));
        }
    }

    default public void woodCrafting(Consumer<FinishedRecipe> consumer, WoodBlockObject wood, String folder) {
        InventoryChangeTrigger.TriggerInstance hasPlanks = RecipeProvider.m_125977_((ItemLike)wood);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood, (int)4).m_206419_(wood.getLogItemTag()).m_126145_("planks").m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(wood.getLogItemTag()).m_45077_()})).m_126140_(consumer, this.location(folder + "planks"));
        SlabBlock slab = wood.getSlab();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("###").m_126132_("has_planks", (CriterionTriggerInstance)hasPlanks).m_126145_("wooden_slab").m_126140_(consumer, this.location(folder + "slab"));
        StairBlock stairs = wood.getStairs();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126132_("has_planks", (CriterionTriggerInstance)hasPlanks).m_126145_("wooden_stairs").m_126140_(consumer, this.location(folder + "stairs"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood.getWood(), (int)3).m_126127_(Character.valueOf('#'), (ItemLike)wood.getLog()).m_126130_("##").m_126130_("##").m_126145_("bark").m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)wood.getLog())).m_126140_(consumer, this.location(folder + "log_to_wood"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood.getStrippedWood(), (int)3).m_126127_(Character.valueOf('#'), (ItemLike)wood.getStrippedLog()).m_126130_("##").m_126130_("##").m_126145_("bark").m_126132_("has_log", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)wood.getStrippedLog())).m_126140_(consumer, this.location(folder + "stripped_log_to_wood"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wood.getFence(), (int)3).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('W'), (ItemLike)wood).m_126130_("W#W").m_126130_("W#W").m_126145_("wooden_fence").m_126132_("has_planks", (CriterionTriggerInstance)hasPlanks).m_126140_(consumer, this.location(folder + "fence"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)wood.getFenceGate()).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('W'), (ItemLike)wood).m_126130_("#W#").m_126130_("#W#").m_126145_("wooden_fence_gate").m_126132_("has_planks", (CriterionTriggerInstance)hasPlanks).m_126140_(consumer, this.location(folder + "fence_gate"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)wood.getDoor(), (int)3).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("##").m_126130_("##").m_126130_("##").m_126145_("wooden_door").m_126132_("has_planks", (CriterionTriggerInstance)hasPlanks).m_126140_(consumer, this.location(folder + "door"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)wood.getTrapdoor(), (int)2).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("###").m_126130_("###").m_126145_("wooden_trapdoor").m_126132_("has_planks", (CriterionTriggerInstance)hasPlanks).m_126140_(consumer, this.location(folder + "trapdoor"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)wood.getButton()).m_126209_((ItemLike)wood).m_126145_("wooden_button").m_126132_("has_planks", (CriterionTriggerInstance)hasPlanks).m_126140_(consumer, this.location(folder + "button"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)wood.getPressurePlate()).m_126127_(Character.valueOf('#'), (ItemLike)wood).m_126130_("##").m_126145_("wooden_pressure_plate").m_126132_("has_planks", (CriterionTriggerInstance)hasPlanks).m_126140_(consumer, this.location(folder + "pressure_plate"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wood.getSign(), (int)3).m_126145_("sign").m_126127_(Character.valueOf('#'), (ItemLike)wood).m_206416_(Character.valueOf('X'), Tags.Items.RODS_WOODEN).m_126130_("###").m_126130_("###").m_126130_(" X ").m_126132_("has_planks", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)wood)).m_126140_(consumer, this.location(folder + "sign"));
    }
}

