/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.render.FluidRenderer;

public class FaucetFluidLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final FaucetFluidLoader INSTANCE = new FaucetFluidLoader();
    private static final ResourceLocation DEFAULT_NAME = Mantle.getResource("_default");
    private final Map<BlockState, FaucetFluid> fluidMap = new HashMap<BlockState, FaucetFluid>();
    private static boolean initialized = false;
    private FaucetFluid defaultFluid = FaucetFluid.EMPTY;

    public static void initialize(RegisterClientReloadListenersEvent event) {
        if (initialized) {
            return;
        }
        initialized = true;
        event.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    private FaucetFluidLoader() {
        super(GSON, "models/faucet_fluid");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        JsonElement def = map.get(DEFAULT_NAME);
        if (def == null || !def.isJsonObject()) {
            Mantle.logger.warn("Found no default fluid model, this is likely a problem with the resource pack");
            this.defaultFluid = FaucetFluid.EMPTY;
        } else {
            try {
                this.defaultFluid = FaucetFluid.parseDefault(def.getAsJsonObject());
            }
            catch (Exception exception) {
                Mantle.logger.error("Failed to load default faucet fluid model {}", (Object)DEFAULT_NAME, (Object)exception);
            }
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (location.equals((Object)DEFAULT_NAME) || !entry.getValue().isJsonObject()) continue;
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"");
                JsonObject variants = GsonHelper.m_13930_((JsonObject)json, (String)"variants");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
                if (block != null && block != Blocks.f_50016_) {
                    StateDefinition container = block.m_49965_();
                    ImmutableList validStates = container.m_61056_();
                    for (Map.Entry variant : variants.entrySet()) {
                        FaucetFluid fluid = FaucetFluid.fromJson(GsonHelper.m_13918_((JsonElement)((JsonElement)variant.getValue()), (String)((String)variant.getKey())), this.defaultFluid);
                        validStates.stream().filter(ModelBakery.m_119273_((StateDefinition)container, (String)((String)variant.getKey()))).forEach(state -> this.fluidMap.put((BlockState)state, fluid));
                    }
                    continue;
                }
                Mantle.logger.debug("Skipping loading faucet fluid model '{}' as no coorsponding block exists", (Object)location);
            }
            catch (Exception e) {
                Mantle.logger.warn("Exception loading faucet fluid model '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    public static FaucetFluid get(BlockState state) {
        return FaucetFluidLoader.INSTANCE.fluidMap.getOrDefault(state, FaucetFluidLoader.INSTANCE.defaultFluid);
    }

    public static void renderFaucetFluids(LevelAccessor world, BlockPos pos, Direction direction, PoseStack matrices, VertexConsumer buffer, TextureAtlasSprite still, TextureAtlasSprite flowing, int color, int light) {
        FaucetFluid faucetFluid;
        int i = 0;
        do {
            faucetFluid = FaucetFluidLoader.get(world.m_8055_(pos.m_6625_(++i)));
            matrices.m_85836_();
            matrices.m_252880_(0.0f, (float)(-i), 0.0f);
            for (FluidCuboid cube : faucetFluid.getFluids(direction)) {
                FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, false);
            }
            matrices.m_85849_();
        } while (faucetFluid.isContinued());
    }

    public static class FaucetFluid {
        private static final FaucetFluid EMPTY = new FaucetFluid(Collections.emptyList(), Collections.emptyList(), false);
        private final List<FluidCuboid> side;
        private final List<FluidCuboid> center;
        private final boolean cont;

        public FaucetFluid(List<FluidCuboid> side, List<FluidCuboid> center, boolean cont) {
            this.side = side;
            this.center = center;
            this.cont = cont;
        }

        public List<FluidCuboid> getFluids(Direction dir) {
            if (dir.m_122434_() == Direction.Axis.Y) {
                return this.center;
            }
            return this.side;
        }

        public boolean isContinued() {
            return this.cont;
        }

        protected static FaucetFluid parseDefault(JsonObject json) {
            List<FluidCuboid> side = FluidCuboid.listFromJson(json, "side");
            List<FluidCuboid> center = FluidCuboid.listFromJson(json, "center");
            return new FaucetFluid(side, center, false);
        }

        protected static FaucetFluid fromJson(JsonObject json, FaucetFluid def) {
            List<FluidCuboid> side = FaucetFluid.parseFluids(json, "side", def.side);
            List<FluidCuboid> center = FaucetFluid.parseFluids(json, "center", def.center);
            boolean cont = GsonHelper.m_13855_((JsonObject)json, (String)"continue", (boolean)false);
            return new FaucetFluid(side, center, cont);
        }

        private static List<FluidCuboid> parseFluids(JsonObject json, String tag, List<FluidCuboid> def) {
            JsonElement element;
            if (json.has(tag)) {
                element = json.get(tag);
            } else if (json.has("bottom") && json.get("bottom").isJsonPrimitive()) {
                element = json.get("bottom");
            } else {
                return def;
            }
            if (element.isJsonPrimitive()) {
                int value = element.getAsInt();
                return def.stream().map(cuboid -> {
                    Vector3f from = new Vector3f((Vector3fc)cuboid.getFrom());
                    from.y = value;
                    return new FluidCuboid(from, cuboid.getTo(), cuboid.getFaces());
                }).collect(Collectors.toList());
            }
            return FluidCuboid.listFromJson(json, tag);
        }
    }
}

