/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;

public class FlowingFluidObject<F extends FlowingFluid>
extends FluidObject<F> {
    @Nonnull
    private final TagKey<Fluid> localTag;
    private final Supplier<? extends F> flowing;
    @Nullable
    private final Supplier<? extends LiquidBlock> block;

    public FlowingFluidObject(ResourceLocation id, String tagName, Supplier<? extends FluidType> type, Supplier<? extends F> still, Supplier<? extends F> flowing, @Nullable Supplier<? extends LiquidBlock> block) {
        super(id, tagName, type, still);
        this.localTag = FluidTags.create((ResourceLocation)id);
        this.flowing = flowing;
        this.block = block;
    }

    public F getStill() {
        return (F)((FlowingFluid)this.get());
    }

    public F getFlowing() {
        return (F)Objects.requireNonNull((FlowingFluid)this.flowing.get(), "Fluid object missing flowing fluid");
    }

    @Nullable
    public LiquidBlock getBlock() {
        if (this.block == null) {
            return null;
        }
        return this.block.get();
    }

    @Override
    public FluidIngredient ingredient(int amount, boolean commonTag) {
        return FluidIngredient.of(commonTag ? this.getForgeTag() : this.getLocalTag(), amount);
    }

    @Nonnull
    public TagKey<Fluid> getLocalTag() {
        return this.localTag;
    }
}

