/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.texture;

import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.texture.FluidTexture;
import slimeknights.mantle.util.JsonHelper;

public class FluidTextureManager
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER = "mantle/fluid_texture";
    private static final FluidTextureManager INSTANCE = new FluidTextureManager();
    private Map<FluidType, FluidTexture> textures = Collections.emptyMap();
    private static final FluidTexture FALLBACK = new FluidTexture(new ResourceLocation("block/water_still"), new ResourceLocation("block/water_flow"), null, null, -1);

    private FluidTextureManager() {
        super(JsonHelper.DEFAULT_GSON, FOLDER);
    }

    public static void init(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        long time = System.nanoTime();
        HashMap<FluidType, FluidTexture> map = new HashMap<FluidType, FluidTexture>();
        IForgeRegistry fluidTypeRegistry = (IForgeRegistry)ForgeRegistries.FLUID_TYPES.get();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation id = entry.getKey();
            FluidType type = (FluidType)fluidTypeRegistry.getValue(id);
            if (type == null || !id.equals((Object)fluidTypeRegistry.getKey((Object)type))) {
                Mantle.logger.debug("Ignoring fluid texture {} as no fluid type exists with that name", (Object)id);
                continue;
            }
            map.put(type, FluidTexture.deserialize(GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"fluid_texture")));
        }
        this.textures = map;
        Mantle.logger.info("Loaded {} fluid textures in {} ms", (Object)map.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public static FluidTexture getData(FluidType fluid) {
        return FluidTextureManager.INSTANCE.textures.getOrDefault(fluid, FALLBACK);
    }

    public static ResourceLocation getStillTexture(FluidType fluid) {
        return FluidTextureManager.getData(fluid).still();
    }

    public static ResourceLocation getFlowingTexture(FluidType fluid) {
        return FluidTextureManager.getData(fluid).flowing();
    }

    @Nullable
    public static ResourceLocation getOverlayTexture(FluidType fluid) {
        return FluidTextureManager.getData(fluid).overlay();
    }

    @Nullable
    public static ResourceLocation getCameraTexture(FluidType fluid) {
        return FluidTextureManager.getData(fluid).camera();
    }

    public static int getColor(FluidType fluid) {
        return FluidTextureManager.getData(fluid).color();
    }
}

