/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.util.html.HtmlGroup;
import slimeknights.mantle.util.html.HtmlSerializable;
import slimeknights.mantle.util.html.HtmlString;

public class HtmlElement
extends HtmlGroup {
    private static final Set<String> SELF_CLOSING = Set.of("area", "base", "br", "col", "embed", "hr", "img", "input", "link", "meta", "param", "source", "track", "wbr");
    private final String tag;
    private final List<String> classes = new ArrayList<String>();
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final Map<String, String> style = new LinkedHashMap<String, String>();
    private final boolean selfClosing;

    private HtmlElement(String tag, boolean indentChildren) {
        super(indentChildren);
        this.tag = tag;
        this.selfClosing = SELF_CLOSING.contains(tag);
    }

    public static HtmlElement indent(String tag) {
        return new HtmlElement(tag, true);
    }

    public static HtmlElement inline(String tag) {
        return new HtmlElement(tag, false);
    }

    @Override
    public HtmlGroup add(HtmlSerializable element) {
        if (this.selfClosing) {
            throw new IllegalStateException("Cannot add children to self-closing elements");
        }
        return super.add(element);
    }

    public HtmlElement classes(String ... classes) {
        Collections.addAll(this.classes, classes);
        return this;
    }

    public HtmlElement attribute(String name, String value) {
        if ("style".equals(name)) {
            throw new IllegalArgumentException("Use HtmlElement#style()");
        }
        if ("class".equals(name)) {
            return this.classes(value);
        }
        this.attributes.put(name, value);
        return this;
    }

    public HtmlElement id(String id) {
        return this.attribute("id", id);
    }

    public HtmlElement minetip(String text) {
        return this.attribute("data-minetip-title", text);
    }

    public HtmlElement style(String name, String value) {
        this.style.put(name, value);
        return this;
    }

    public HtmlElement style(String name, int value) {
        return this.style(name, value + "px");
    }

    public HtmlElement style(String name, float value) {
        return this.style(name, Math.round(value * 100.0f) + "%");
    }

    public HtmlElement color(String name, int color) {
        return this.style("color", "#" + ColorLoadable.NO_ALPHA.getString(color));
    }

    public HtmlElement color(int color) {
        return this.color("color", color);
    }

    public HtmlElement bold() {
        return this.style("font-weight", "bold");
    }

    public HtmlElement italic() {
        return this.style("font-weight", "italic");
    }

    public HtmlElement underline() {
        return this.style("text-decoration", "underline");
    }

    public HtmlElement strikeout() {
        return this.style("text-decoration", "strikeout");
    }

    @Override
    public void toHtml(StringBuilder builder, String indent) {
        builder.append('<').append(this.tag);
        if (!this.classes.isEmpty()) {
            builder.append(" class=\"");
            builder.append(String.join((CharSequence)" ", this.classes));
            builder.append('\"');
        }
        for (Map.Entry<String, String> entry2 : this.attributes.entrySet()) {
            builder.append(" ").append(entry2.getKey()).append("=\"").append(HtmlString.escapeString(entry2.getValue())).append('\"');
        }
        if (!this.style.isEmpty()) {
            builder.append(" style=\"");
            builder.append(this.style.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue() + ";").collect(Collectors.joining(" ")));
            builder.append('\"');
        }
        if (this.selfClosing) {
            builder.append("/>");
        } else if (this.children.isEmpty()) {
            builder.append("></").append(this.tag).append('>');
        } else {
            builder.append('>');
            if (this.indentChildren) {
                builder.append('\n');
            }
            super.toHtml(builder, indent + "  ");
            if (this.indentChildren) {
                builder.append(indent);
            }
            builder.append("</").append(this.tag).append('>');
        }
    }

    @Override
    public String toString() {
        String s = "<" + this.tag + ">";
        if (!this.children.isEmpty()) {
            s = s + "[" + this.children.stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
        }
        return s;
    }

    public static HtmlElement div() {
        return HtmlElement.indent("div");
    }

    public static HtmlElement ul() {
        return HtmlElement.indent("ul");
    }

    public static HtmlElement li() {
        return HtmlElement.indent("li");
    }

    public static HtmlElement p() {
        return HtmlElement.inline("p");
    }

    public static HtmlElement span() {
        return HtmlElement.inline("span");
    }

    public static HtmlElement b() {
        return HtmlElement.inline("b");
    }

    public static HtmlElement i() {
        return HtmlElement.inline("i");
    }

    public static HtmlSerializable br() {
        return HtmlElement.inline("br");
    }
}

