/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import slimeknights.mantle.util.OffhandCooldownTracker;

public class CombatHelper {
    private static final float TO_RADIAN = (float)Math.PI / 180;
    private static final AttributeModifier ANTI_KNOCKBACK_MODIFIER = new AttributeModifier("mantle.anti_knockback", 1.0, AttributeModifier.Operation.ADDITION);
    public static final ToolAction NO_BASE_KNOCKBACK = ToolAction.get((String)"no_base_knockback");

    private CombatHelper() {
    }

    public static ItemStack getMainhandAttributeStack(LivingEntity entity) {
        if (entity.m_9236_().f_46443_) {
            return entity.m_21205_();
        }
        return entity.m_21244_(EquipmentSlot.MAINHAND);
    }

    public static Map<AttributeModifier.Operation, Set<AttributeModifier>> copyModifiers(AttributeInstance instance) {
        EnumMap<AttributeModifier.Operation, Set<AttributeModifier>> modifiers = new EnumMap<AttributeModifier.Operation, Set<AttributeModifier>>(AttributeModifier.Operation.class);
        for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
            Collection original = instance.m_22116_(operation);
            HashSet copy = new HashSet(original.size());
            copy.addAll(original);
            modifiers.put(operation, copy);
        }
        return modifiers;
    }

    public static float getOffhandAttribute(ItemStack stack, LivingEntity entity, Attribute attribute) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return (float)entity.m_21172_(attribute);
        }
        ItemStack mainStack = CombatHelper.getMainhandAttributeStack(entity);
        Collection mainModifiers = List.of();
        if (!mainStack.m_41619_()) {
            mainModifiers = mainStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)attribute);
        }
        Collection offhandModifiers = stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)attribute);
        if (mainModifiers.isEmpty() && offhandModifiers.isEmpty()) {
            return (float)instance.m_22135_();
        }
        Map<AttributeModifier.Operation, Set<AttributeModifier>> modifiers = CombatHelper.copyModifiers(instance);
        for (AttributeModifier modifier : mainModifiers) {
            modifiers.get(modifier.m_22217_()).remove(modifier);
        }
        for (AttributeModifier modifier : offhandModifiers) {
            modifiers.get(modifier.m_22217_()).add(modifier);
        }
        return (float)CombatHelper.computeAttribute(attribute, instance.m_22115_(), modifiers);
    }

    public static double computeAttribute(Attribute attribute, double base, Map<AttributeModifier.Operation, Set<AttributeModifier>> modifiers) {
        for (AttributeModifier modifier : modifiers.get(AttributeModifier.Operation.ADDITION)) {
            base += modifier.m_22218_();
        }
        double value = base;
        for (AttributeModifier modifier : modifiers.get(AttributeModifier.Operation.MULTIPLY_BASE)) {
            value += base * modifier.m_22218_();
        }
        for (AttributeModifier modifier : modifiers.get(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            value *= 1.0 + modifier.m_22218_();
        }
        return attribute.m_6740_(value);
    }

    public static boolean isAttackable(Entity attacker, Entity target) {
        return target.m_6097_() && !target.m_7313_(attacker);
    }

    public static boolean attack(ItemStack stack, Player player, Entity target, @Nullable LivingEntity targetLiving, InteractionHand hand) {
        return CombatHelper.attack(stack, player, target, targetLiving, hand, player.m_269291_().m_269075_(player));
    }

    public static boolean attack(ItemStack stack, Player player, Entity target, @Nullable LivingEntity targetLiving, InteractionHand hand, DamageSource damageSource) {
        if (CombatHelper.isAttackable((Entity)player, target)) {
            float damage = hand == InteractionHand.OFF_HAND ? CombatHelper.getOffhandAttribute(stack, (LivingEntity)player, Attributes.f_22281_) : (float)player.m_21133_(Attributes.f_22281_);
            float enchantmentDamage = targetLiving != null ? EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)targetLiving.m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
            float cooldown = hand == InteractionHand.OFF_HAND ? OffhandCooldownTracker.getCooldown(player) : player.m_36403_(0.5f);
            enchantmentDamage *= cooldown;
            if ((damage *= 0.2f + cooldown * cooldown * 0.8f) > 0.0f || enchantmentDamage > 0.0f) {
                boolean hit;
                boolean fullyCharged = cooldown > 0.9f;
                float knockback = hand == InteractionHand.OFF_HAND ? CombatHelper.getOffhandAttribute(stack, (LivingEntity)player, Attributes.f_22282_) : (float)player.m_21133_(Attributes.f_22282_);
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)player);
                boolean sprinting = false;
                if (player.m_20142_() && fullyCharged) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12314_, player.m_5720_(), 1.0f, 1.0f);
                    knockback += 1.0f;
                    sprinting = true;
                }
                boolean critical = fullyCharged && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20142_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && targetLiving != null;
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)critical, (float)(critical ? 1.5f : 1.0f));
                boolean bl = critical = hitResult != null;
                if (critical) {
                    damage *= hitResult.getDamageModifier();
                }
                damage += enchantmentDamage;
                boolean canSweep = fullyCharged && !critical && !sprinting && player.m_20096_() && player.f_19787_ - player.f_19867_ < player.m_6113_() && stack.canPerformAction(ToolActions.SWORD_SWEEP);
                float health = 0.0f;
                boolean fakeFire = false;
                int fire = EnchantmentHelper.m_44914_((LivingEntity)player);
                if (targetLiving != null) {
                    health = targetLiving.m_21223_();
                    if (fire > 0 && !target.m_6060_()) {
                        fakeFire = true;
                        target.m_20254_(1);
                    }
                }
                Vec3 movement = target.m_20184_();
                if (stack.canPerformAction(NO_BASE_KNOCKBACK) && targetLiving != null) {
                    AttributeInstance knockbackAttribute = targetLiving.m_21051_(Attributes.f_22278_);
                    if (knockbackAttribute != null && !knockbackAttribute.m_22109_(ANTI_KNOCKBACK_MODIFIER)) {
                        knockbackAttribute.m_22118_(ANTI_KNOCKBACK_MODIFIER);
                        hit = target.m_6469_(damageSource, damage);
                        knockbackAttribute.m_22130_(ANTI_KNOCKBACK_MODIFIER);
                    } else {
                        hit = target.m_6469_(damageSource, damage);
                    }
                } else {
                    hit = target.m_6469_(damageSource, damage);
                }
                if (hit) {
                    if (knockback > 0.0f) {
                        if (targetLiving != null) {
                            targetLiving.m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                        } else {
                            target.m_5997_((double)(-Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))) * knockback * 0.5f), 0.1, (double)(Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180))) * knockback * 0.5f));
                        }
                        player.m_20256_(player.m_20184_().m_82542_(0.6, 1.0, 0.6));
                        player.m_6858_(false);
                    }
                    if (canSweep) {
                        float sweepDamage = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)player) * damage;
                        for (LivingEntity living : player.m_9236_().m_45976_(LivingEntity.class, stack.getSweepHitBox(player, target))) {
                            ArmorStand armorStand;
                            double entityReachSq = Mth.m_144952_((double)player.getEntityReach());
                            if (living == player || living == targetLiving || player.m_7307_((Entity)living) || living instanceof ArmorStand && (armorStand = (ArmorStand)living).m_31677_() || !(player.m_20280_((Entity)living) < entityReachSq)) continue;
                            living.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                            living.m_6469_(player.m_269291_().m_269075_(player), sweepDamage);
                        }
                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
                        player.m_36346_();
                    }
                    if (target instanceof ServerPlayer) {
                        ServerPlayer serverTarget = (ServerPlayer)target;
                        if (target.f_19864_) {
                            serverTarget.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(target));
                            target.f_19864_ = false;
                            target.m_20256_(movement);
                        }
                    }
                    if (critical) {
                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12313_, player.m_5720_(), 1.0f, 1.0f);
                        player.m_5704_(target);
                    } else if (fullyCharged) {
                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12316_, player.m_5720_(), 1.0f, 1.0f);
                    } else {
                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12318_, player.m_5720_(), 1.0f, 1.0f);
                    }
                    if (enchantmentDamage > 0.0f) {
                        player.m_5700_(target);
                    }
                    player.m_21335_(target);
                    if (targetLiving != null) {
                        EnchantmentHelper.m_44823_((LivingEntity)targetLiving, (Entity)player);
                    }
                    EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)target);
                    Entity parent = target;
                    if (target instanceof PartEntity) {
                        PartEntity part = (PartEntity)target;
                        parent = part.getParent();
                    }
                    if (!player.m_9236_().f_46443_ && !stack.m_41619_() && parent instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)parent;
                        ItemStack copy = stack.m_41777_();
                        stack.m_41640_(living, player);
                        if (stack.m_41619_()) {
                            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)hand);
                            player.m_21008_(hand, ItemStack.f_41583_);
                        }
                    }
                    if (targetLiving != null) {
                        Level level;
                        float damageDealt = health - targetLiving.m_21223_();
                        player.m_36222_(Stats.f_12928_, Math.round(damageDealt * 10.0f));
                        if (fire > 0) {
                            target.m_20254_(fire * 4);
                        }
                        if ((level = player.m_9236_()) instanceof ServerLevel) {
                            ServerLevel server = (ServerLevel)level;
                            if (damageDealt > 2.0f) {
                                server.m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), (int)((double)damageDealt * 0.5), 0.1, 0.0, 0.1, 0.2);
                            }
                        }
                    }
                    player.m_36399_(0.1f);
                } else {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12315_, player.m_5720_(), 1.0f, 1.0f);
                    if (fakeFire) {
                        target.m_20095_();
                    }
                }
            }
            if (hand == InteractionHand.OFF_HAND) {
                OffhandCooldownTracker.applyCooldown(player, CombatHelper.getOffhandAttribute(stack, (LivingEntity)player, Attributes.f_22283_), 20);
            } else {
                player.m_36334_();
            }
            return true;
        }
        return false;
    }

    public static Holder<DamageType> damageType(RegistryAccess access, ResourceKey<DamageType> key) {
        return access.m_175515_(Registries.f_268580_).m_246971_(key);
    }

    public static DamageSource damageSource(RegistryAccess access, ResourceKey<DamageType> key) {
        return new DamageSource(CombatHelper.damageType(access, key));
    }

    public static DamageSource damageSource(Level level, ResourceKey<DamageType> key) {
        return new DamageSource(CombatHelper.damageType(level.m_9598_(), key));
    }

    public static DamageSource damageSource(ResourceKey<DamageType> key, Entity entity) {
        return new DamageSource(CombatHelper.damageType(entity.m_9236_().m_9598_(), key), entity);
    }

    public static DamageSource damageSource(ResourceKey<DamageType> key, Entity direct, @Nullable Entity causing) {
        return new DamageSource(CombatHelper.damageType(direct.m_9236_().m_9598_(), key), direct, causing);
    }
}

