/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.MantleRecipes;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.RetexturedHelper;

public class ShapedRetexturedRecipe
extends ShapedRecipe {
    private final Ingredient texture;
    private final boolean matchAll;

    protected ShapedRetexturedRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, boolean showNotification, Ingredient texture, boolean matchAll) {
        super(id, group, category, width, height, ingredients, result, showNotification);
        this.texture = texture;
        this.matchAll = matchAll;
    }

    protected ShapedRetexturedRecipe(ShapedRecipe orig, Ingredient texture, boolean matchAll) {
        this(orig.m_6423_(), orig.m_6076_(), orig.m_245232_(), orig.m_44220_(), orig.m_44221_(), (NonNullList<Ingredient>)orig.m_7527_(), orig.f_44149_, orig.m_271738_(), texture, matchAll);
    }

    public ItemStack getResultItem(Item texture, RegistryAccess access) {
        return RetexturedHelper.setTexture(this.m_8043_(access).m_41777_(), Block.m_49814_((Item)texture));
    }

    public ItemStack m_5874_(CraftingContainer craftMatrix, RegistryAccess access) {
        ItemStack result = super.m_5874_(craftMatrix, access);
        Block currentTexture = null;
        for (int i = 0; i < craftMatrix.m_6643_(); ++i) {
            ItemStack stack = craftMatrix.m_8020_(i);
            if (stack.m_41619_() || !this.texture.test(stack)) continue;
            Block block = RetexturedHelper.getTexture(stack);
            if (block == Blocks.f_50016_ && stack.m_41720_() != result.m_41720_()) {
                block = Block.m_49814_((Item)stack.m_41720_());
            }
            if (block == Blocks.f_50016_) continue;
            if (currentTexture == null) {
                currentTexture = block;
                if (this.matchAll) continue;
                break;
            }
            if (currentTexture == block) continue;
            currentTexture = null;
            break;
        }
        if (currentTexture != null) {
            return RetexturedHelper.setTexture(result, currentTexture);
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MantleRecipes.CRAFTING_SHAPED_RETEXTURED.get();
    }

    public Ingredient getTexture() {
        return this.texture;
    }

    public static class Serializer
    implements LoggingRecipeSerializer<ShapedRetexturedRecipe> {
        public ShapedRetexturedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient texture;
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map key = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44186_((String[])ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList inputs = ShapedRecipe.m_44202_((String[])pattern, (Map)key, (int)width, (int)height);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            boolean showNotification = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
            JsonElement textureElement = JsonHelper.getElement(json, "texture");
            if (textureElement.isJsonPrimitive()) {
                String textureKey = textureElement.getAsString();
                if (textureKey.length() != 1) {
                    throw new JsonSyntaxException("Invalid texture key: '" + textureKey + "' is an invalid symbol (must be 1 character only).");
                }
                texture = (Ingredient)key.get(textureKey);
                if (texture == null || texture == Ingredient.f_43901_) {
                    throw new JsonSyntaxException("Texture ingredient references symbol '" + textureKey + "' but it's not defined in the key");
                }
            } else {
                texture = CraftingHelper.getIngredient((JsonElement)textureElement, (boolean)false);
                Mantle.logger.warn("Using deprecated ingredient format on 'texture' for `mantle:crafting_shaped_retextured`. Use key instead.");
            }
            boolean matchAll = false;
            if (json.has("match_all")) {
                matchAll = json.get("match_all").getAsBoolean();
            }
            return new ShapedRetexturedRecipe(recipeId, group, category, width, height, (NonNullList<Ingredient>)inputs, result, showNotification, texture, matchAll);
        }

        @Override
        @Nullable
        public ShapedRetexturedRecipe fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)f_44076_.m_8005_(recipeId, buffer);
            return recipe == null ? null : new ShapedRetexturedRecipe(recipe, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readBoolean());
        }

        @Override
        public void toNetworkSafe(FriendlyByteBuf buffer, ShapedRetexturedRecipe recipe) {
            f_44076_.m_6178_(buffer, (Recipe)recipe);
            recipe.texture.m_43923_(buffer);
            buffer.writeBoolean(recipe.matchAll);
        }
    }
}

