/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.RegistryPredicateRegistry;

public interface LivingEntityPredicate
extends IJsonPredicate<LivingEntity> {
    public static final LivingEntityPredicate ANY = LivingEntityPredicate.simple(entity -> true);
    public static final LivingEntityPredicate NONE = LivingEntityPredicate.simple(entity -> false);
    public static final RegistryPredicateRegistry<EntityType<?>, LivingEntity> LOADER = new RegistryPredicateRegistry<EntityType, LivingEntity>("Entity Predicate", ANY, NONE, Loadables.ENTITY_TYPE, Entity::m_6095_, "entities", Loadables.ENTITY_TYPE_TAG, (tag, entity) -> entity.m_6095_().m_204039_(tag));
    public static final LivingEntityPredicate WATER_SENSITIVE = LivingEntityPredicate.simple(LivingEntity::m_6126_);
    public static final LivingEntityPredicate FIRE_IMMUNE = LivingEntityPredicate.simple(Entity::m_5825_);
    public static final LivingEntityPredicate ON_FIRE = LivingEntityPredicate.simple(Entity::m_6060_);
    public static final LivingEntityPredicate CAN_FREEZE = LivingEntityPredicate.simple(Entity::m_142079_);
    public static final LivingEntityPredicate IS_FREEZING = LivingEntityPredicate.simple(entity -> entity.m_146888_() >= entity.m_146891_());
    public static final LivingEntityPredicate IS_IN_POWDERED_SNOW = LivingEntityPredicate.simple(Entity::m_203117_);
    public static final LivingEntityPredicate ON_GROUND = LivingEntityPredicate.simple(Entity::m_20096_);
    public static final LivingEntityPredicate CROUCHING = LivingEntityPredicate.simple(Entity::m_6047_);
    public static final LivingEntityPredicate SPRINTING = LivingEntityPredicate.simple(Entity::m_20142_);
    public static final LivingEntityPredicate BLOCKING = LivingEntityPredicate.simple(LivingEntity::m_21254_);
    public static final LivingEntityPredicate ELYTRA_FLYING = LivingEntityPredicate.simple(LivingEntity::m_21255_);
    public static final LivingEntityPredicate EYES_IN_WATER = LivingEntityPredicate.simple(entity -> entity.f_19800_);
    public static final LivingEntityPredicate FEET_IN_WATER = LivingEntityPredicate.simple(Entity::m_20069_);
    public static final LivingEntityPredicate UNDERWATER = LivingEntityPredicate.simple(Entity::m_5842_);
    public static final LivingEntityPredicate RAINING = LivingEntityPredicate.simple(entity -> entity.m_9236_().m_46758_(entity.m_20183_()));

    @Override
    default public IJsonPredicate<LivingEntity> inverted() {
        return LOADER.invert(this);
    }

    public static LivingEntityPredicate simple(final Predicate<LivingEntity> predicate) {
        return SingletonLoader.singleton(loader -> new LivingEntityPredicate(){
            final /* synthetic */ RecordLoadable val$loader;
            {
                this.val$loader = recordLoadable;
            }

            @Override
            public boolean matches(LivingEntity entity) {
                return predicate.test(entity);
            }

            @Override
            public RecordLoadable<? extends LivingEntityPredicate> getLoader() {
                return this.val$loader;
            }
        });
    }

    public static IJsonPredicate<LivingEntity> set(EntityType<?> ... types) {
        return LOADER.setOf(types);
    }

    public static IJsonPredicate<LivingEntity> tag(TagKey<EntityType<?>> tag) {
        return LOADER.tag(tag);
    }

    @SafeVarargs
    public static IJsonPredicate<LivingEntity> and(IJsonPredicate<LivingEntity> ... predicates) {
        return LOADER.and(List.of(predicates));
    }

    @SafeVarargs
    public static IJsonPredicate<LivingEntity> or(IJsonPredicate<LivingEntity> ... predicates) {
        return LOADER.or(List.of(predicates));
    }
}

