/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.common.BaseRegistryLoadable;
import slimeknights.mantle.util.RegistryHelper;

public class LazyRegistryLoadable<T>
implements BaseRegistryLoadable<T> {
    private final ResourceKey<? extends Registry<T>> registryKey;
    @Nullable
    private Registry<T> registry;

    @Override
    @Nullable
    public Registry<T> registry() {
        if (this.registry == null) {
            this.registry = RegistryHelper.getRegistry(this.registryKey);
            if (this.registry == null) {
                Mantle.logger.error("Registry {} cannot be located, treating as an empty registry. This may cause serialization issues down the line.", this.registryKey);
            }
        }
        return this.registry;
    }

    @Override
    public ResourceLocation registryId() {
        return this.registryKey.m_135782_();
    }

    public LazyRegistryLoadable(ResourceKey<? extends Registry<T>> registryKey) {
        this.registryKey = registryKey;
    }
}

