/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;

public class HungerCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        subCommand = (LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2));
        for (Operation operation : Operation.values()) {
            operation.register((LiteralArgumentBuilder<CommandSourceStack>)subCommand);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Operation {
        SET(20.0f){

            @Override
            public void apply(FoodData food, int hunger, float saturation) {
                food.f_38696_ = hunger;
                food.f_38697_ = Math.min((float)hunger, saturation);
            }
        }
        ,
        ADD(1.0f){

            @Override
            public void apply(FoodData food, int hunger, float saturation) {
                food.m_38707_(hunger, saturation);
            }
        }
        ,
        SUBTRACT(0.0f){

            @Override
            public void apply(FoodData food, int hunger, float saturation) {
                food.f_38696_ = Math.max(0, food.f_38696_ - hunger);
                food.f_38697_ = Mth.m_14036_((float)(food.f_38697_ - (float)hunger * saturation * 2.0f), (float)0.0f, (float)food.f_38696_);
            }
        };

        private final String name = this.name().toLowerCase(Locale.ROOT);
        private final float defaultSaturation;

        public void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
            subCommand.then(Commands.m_82127_((String)this.name).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"hunger", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(context -> this.run((CommandContext<CommandSourceStack>)context, this.defaultSaturation))).then(Commands.m_82129_((String)"saturation", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> this.run((CommandContext<CommandSourceStack>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"saturation")))))));
        }

        public abstract void apply(FoodData var1, int var2, float var3);

        public int run(CommandContext<CommandSourceStack> context, float saturation) throws CommandSyntaxException {
            Collection players = EntityArgument.m_91477_(context, (String)"targets");
            int hunger = IntegerArgumentType.getInteger(context, (String)"hunger");
            for (Player player : players) {
                this.apply(player.m_36324_(), hunger, saturation);
            }
            if (players.size() == 1) {
                Player player = (Player)players.iterator().next();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)("command.mantle.hunger." + this.name + ".single"), (Object[])new Object[]{player.m_7755_(), hunger}), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)("command.mantle.hunger." + this.name + ".multiple"), (Object[])new Object[]{players.size(), hunger}), true);
            }
            return players.size();
        }

        private Operation(float defaultSaturation) {
            this.defaultSaturation = defaultSaturation;
        }
    }
}

