/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BlockStateLoadable implements RecordLoadable<BlockState>
{
    ALL{

        @Override
        protected <T extends Comparable<T>> void serializeProperty(BlockState serialize, Property<T> property, BlockState defaultState, JsonObject json) {
            json.addProperty(property.m_61708_(), property.m_6940_(serialize.m_61143_(property)));
        }
    }
    ,
    DIFFERENCE{

        @Override
        protected <T extends Comparable<T>> void serializeProperty(BlockState serialize, Property<T> property, BlockState defaultState, JsonObject json) {
            Comparable value = serialize.m_61143_(property);
            if (!value.equals(defaultState.m_61143_(property))) {
                json.addProperty(property.m_61708_(), property.m_6940_(value));
            }
        }
    };


    @Override
    public BlockState convert(JsonElement element, String key, TypedMap context) {
        if (element.isJsonPrimitive()) {
            return Loadables.BLOCK.convert(element, key, context).m_49966_();
        }
        return (BlockState)RecordLoadable.super.convert(element, key, context);
    }

    private static <T extends Comparable<T>> BlockState setValue(BlockState state, Property<T> property, String name) {
        Optional value = property.m_6215_(name);
        if (value.isPresent()) {
            return (BlockState)state.m_61124_(property, (Comparable)value.get());
        }
        throw new JsonSyntaxException("Property " + property + " does not contain value " + name);
    }

    @Override
    public BlockState deserialize(JsonObject json, TypedMap context) {
        Block block = (Block)Loadables.BLOCK.getIfPresent(json, "block", context);
        BlockState state = block.m_49966_();
        if (json.has("properties")) {
            StateDefinition definition = block.m_49965_();
            for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)json, (String)"properties").entrySet()) {
                String key = (String)entry.getKey();
                Property property = definition.m_61081_(key);
                if (property == null) {
                    throw new JsonSyntaxException("Property " + key + " does not exist in block " + block);
                }
                state = BlockStateLoadable.setValue(state, property, GsonHelper.m_13805_((JsonElement)((JsonElement)entry.getValue()), (String)key));
            }
        }
        return state;
    }

    @Override
    public JsonElement serialize(BlockState state) {
        Block block = state.m_60734_();
        if (this == DIFFERENCE && state == block.m_49966_()) {
            return Loadables.BLOCK.serialize(block);
        }
        return RecordLoadable.super.serialize(state);
    }

    protected abstract <T extends Comparable<T>> void serializeProperty(BlockState var1, Property<T> var2, BlockState var3, JsonObject var4);

    @Override
    public void serialize(BlockState state, JsonObject json) {
        Block block = state.m_60734_();
        json.add("block", Loadables.BLOCK.serialize(block));
        BlockState defaultState = block.m_49966_();
        JsonObject properties = new JsonObject();
        for (Property property : block.m_49965_().m_61092_()) {
            this.serializeProperty(state, property, defaultState, properties);
        }
        if (properties.size() > 0) {
            json.add("properties", (JsonElement)properties);
        }
    }

    @Override
    public BlockState decode(FriendlyByteBuf buffer, TypedMap context) {
        return Block.m_49803_((int)buffer.m_130242_());
    }

    @Override
    public void encode(FriendlyByteBuf buffer, BlockState object) {
        buffer.m_130130_(Block.m_49956_((BlockState)object));
    }
}

