/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.fml.ModList;

public enum FallbackModelLoader implements IGeometryLoader<BlockModelWrapper>
{
    INSTANCE;


    public BlockModelWrapper read(JsonObject data, JsonDeserializationContext context) {
        JsonArray models = GsonHelper.m_13933_((JsonObject)data, (String)"models");
        if (models.size() < 2) {
            throw new JsonSyntaxException("Fallback model must contain at least 2 models");
        }
        for (int i = 0; i < models.size(); ++i) {
            String debugName = "models[" + i + "]";
            JsonObject entry = GsonHelper.m_13918_((JsonElement)models.get(i), (String)debugName);
            String modId = null;
            if (entry.has("fallback_mod_id")) {
                modId = GsonHelper.m_13906_((JsonObject)entry, (String)"fallback_mod_id");
            } else if (entry.has("loader")) {
                ResourceLocation loader = new ResourceLocation(GsonHelper.m_13906_((JsonObject)entry, (String)"loader"));
                modId = loader.m_135827_();
            }
            if (modId != null && !ModList.get().isLoaded(modId)) continue;
            try {
                return new BlockModelWrapper((BlockModel)context.deserialize((JsonElement)entry, BlockModel.class));
            }
            catch (JsonSyntaxException e) {
                throw new JsonSyntaxException("Failed to parse fallback model " + debugName, (Throwable)e);
            }
        }
        throw new JsonSyntaxException("Failed to load fallback model, all " + models.size() + " variants had a failed condition");
    }

    record BlockModelWrapper(BlockModel model) implements IUnbakedGeometry<BlockModelWrapper>
    {
        public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return this.model.m_111449_(baker, this.model, spriteGetter, modelTransform, modelLocation, true);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.model.m_5500_(modelGetter);
        }
    }
}

