/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import javax.annotation.Nullable;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.BookLoadException;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.TextElement;

public class ContentError
extends PageContent {
    private final String errorStage;
    @Nullable
    private final Exception exception;

    public ContentError(String errorStage) {
        this(errorStage, null);
    }

    public ContentError(String errorStage, @Nullable Exception e) {
        this.errorStage = errorStage;
        this.exception = e;
    }

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        TextData[] text;
        this.addTitle(list, "Error");
        if (this.exception instanceof BookLoadException) {
            this.buildSimple(list);
            return;
        }
        if (this.exception != null) {
            StackTraceElement[] stackTrace = this.exception.getStackTrace();
            text = new TextData[3 + Math.min(stackTrace.length, 4)];
            text[1] = new TextData("The following error has occurred:");
            text[1].color = "dark_red";
            text[1].paragraph = true;
            String message = this.exception.getMessage();
            text[2] = new TextData(message != null && !message.isEmpty() ? message : this.exception.getClass().getSimpleName());
            text[2].color = "dark_red";
            text[2].paragraph = true;
            text[2].linebreak = true;
            for (int i = 3; i < text.length; ++i) {
                text[i] = new TextData(stackTrace[i - 3].toString());
                text[i].text = text[i].text + "\n";
                text[i].color = "dark_red";
                text[i].linebreak = true;
            }
        } else {
            text = new TextData[]{new TextData(this.errorStage)};
        }
        text[0].color = "dark_red";
        text[0].underlined = true;
        text[0].paragraph = true;
        list.add(new TextElement(0, 16, 182, 160, text));
    }

    public void buildSimple(ArrayList<BookElement> list) {
        TextData[] text = new TextData[]{new TextData(this.exception != null ? this.exception.getMessage() : "")};
        text[0].color = "dark_red";
        list.add(new TextElement(0, 16, 182, 160, text));
    }
}

