/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.mantle.datagen.MantleTags;

@Mod.EventBusSubscriber(modid="mantle", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MantleEvents {
    public static final String SOULBOUND_SLOT = "mantle_soulbound";

    @SubscribeEvent
    static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player && !((player = (Player)entity) instanceof FakePlayer)) {
            Inventory inventory = player.m_150109_();
            int totalSize = inventory.m_6643_();
            for (int i = 0; i < totalSize; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !stack.m_204117_(MantleTags.Items.SOULBOUND)) continue;
                stack.m_41784_().m_128405_(SOULBOUND_SLOT, i);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    static void onPlayerDropItems(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!(entity instanceof FakePlayer)) {
                Collection drops = event.getDrops();
                Iterator iter = drops.iterator();
                Inventory inventory = player.m_150109_();
                ArrayList<ItemEntity> takenSlot = new ArrayList<ItemEntity>();
                while (iter.hasNext()) {
                    ItemEntity itemEntity = (ItemEntity)iter.next();
                    ItemStack stack = itemEntity.m_32055_();
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null || !tag.m_128425_(SOULBOUND_SLOT, 99)) continue;
                    int slot = tag.m_128451_(SOULBOUND_SLOT);
                    if (inventory.m_8020_(slot).m_41619_()) {
                        inventory.m_6836_(slot, stack);
                    } else {
                        takenSlot.add(itemEntity);
                    }
                    iter.remove();
                }
                for (ItemEntity itemEntity : takenSlot) {
                    ItemStack stack = itemEntity.m_32055_();
                    if (inventory.m_36054_(stack)) continue;
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        tag.m_128473_(SOULBOUND_SLOT);
                        if (tag.m_128456_()) {
                            stack.m_41751_(null);
                        }
                    }
                    drops.add(itemEntity);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        if (clone.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || original.m_5833_()) {
            return;
        }
        Inventory originalInv = original.m_150109_();
        Inventory cloneInv = clone.m_150109_();
        int size = Math.min(originalInv.m_6643_(), cloneInv.m_6643_());
        ArrayList<ItemStack> takenSlot = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag;
            ItemStack stack = originalInv.m_8020_(i);
            if (stack.m_41619_() || (tag = stack.m_41783_()) == null || !tag.m_128425_(SOULBOUND_SLOT, 99)) continue;
            if (cloneInv.m_8020_(i).m_41619_()) {
                cloneInv.m_6836_(i, stack);
            } else {
                takenSlot.add(stack);
            }
            tag.m_128473_(SOULBOUND_SLOT);
            if (!tag.m_128456_()) continue;
            stack.m_41751_(null);
        }
        for (ItemStack stack : takenSlot) {
            if (cloneInv.m_36054_(stack)) continue;
            clone.m_36176_(stack, false);
        }
    }
}

