/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;
import slimeknights.mantle.data.loadable.IAmLoadable;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.mapping.EitherLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.RegistryHelper;

public abstract class EntityIngredient
implements Predicate<EntityType<?>>,
IAmLoadable {
    public static final EntityIngredient EMPTY = new Compound(Collections.emptyList());
    private static final RecordLoadable<EntityIngredient> ENTRY_MATCH = RecordLoadable.create(Loadables.ENTITY_TYPE.requiredField("type", i -> {
        Set<EntityType<?>> types = i.getTypes();
        if (types.size() == 1) {
            return types.iterator().next();
        }
        throw new IllegalStateException("Cannot use entry match to serialize more than 1 entity");
    }), xva$0 -> EntityIngredient.of(xva$0));
    private static final RecordLoadable<EntityIngredient> SET_MATCH = RecordLoadable.create(Loadables.ENTITY_TYPE.set().requiredField("types", EntityIngredient::getTypes), EntityIngredient::of);
    private static final RecordLoadable<TagMatch> TAG_MATCH = RecordLoadable.create(Loadables.ENTITY_TYPE_TAG.requiredField("tag", t -> t.tag), TagMatch::new);
    private static final Loadable<Compound> COMPOUND = EntityIngredient.loadableBuilder().build(SET_MATCH).list(2).flatXmap(Compound::new, c -> c.ingredients);
    public static final Loadable<EntityIngredient> LOADABLE = EntityIngredient.loadableBuilder().array(COMPOUND).build(SET_MATCH);
    private List<EntityInput> display;
    private List<ItemStack> eggs;

    private static EitherLoadable.TypedBuilder<EntityIngredient> loadableBuilder() {
        return EitherLoadable.typed().key("types", SET_MATCH).key("type", ENTRY_MATCH).key("tag", TAG_MATCH);
    }

    public static EntityIngredient of(Set<EntityType<?>> set) {
        if (set.isEmpty()) {
            return EMPTY;
        }
        return new SetMatch(set);
    }

    public static EntityIngredient of(EntityType<?> ... types) {
        return EntityIngredient.of(ImmutableSet.copyOf((Object[])types));
    }

    public static EntityIngredient of(TagKey<EntityType<?>> tag) {
        return new TagMatch(tag);
    }

    public static EntityIngredient of(EntityIngredient ... ingredients) {
        return EntityIngredient.of(List.of(ingredients));
    }

    private static EntityIngredient of(List<EntityIngredient> ingredients) {
        if (ingredients.isEmpty()) {
            return EMPTY;
        }
        if (ingredients.size() == 1) {
            return ingredients.get(0);
        }
        return new Compound(ingredients);
    }

    public abstract Set<EntityType<?>> getTypes();

    @Deprecated(forRemoval=true)
    public JsonElement serialize() {
        return LOADABLE.serialize(this);
    }

    @Deprecated(forRemoval=true)
    public void write(FriendlyByteBuf buffer) {
        SET_MATCH.encode(buffer, this);
    }

    @Deprecated(forRemoval=true)
    public static EntityIngredient read(FriendlyByteBuf buffer) {
        return (EntityIngredient)SET_MATCH.decode(buffer);
    }

    public List<EntityInput> getDisplay() {
        if (this.display == null) {
            this.display = EntityInput.wrap(this.getTypes());
        }
        return this.display;
    }

    public List<ItemStack> getEggs() {
        if (this.eggs == null) {
            this.eggs = this.getDisplay().stream().map(type -> new ItemStack((ItemLike)Objects.requireNonNullElse(ForgeSpawnEggItem.fromEntityType(type.type), Items.f_41852_))).toList();
        }
        return this.eggs;
    }

    private static class SetMatch
    extends EntityIngredient {
        private final Set<EntityType<?>> types;

        public Loadable<? extends EntityIngredient> loadable() {
            return this.types.size() == 1 ? ENTRY_MATCH : SET_MATCH;
        }

        @Override
        public boolean test(EntityType<?> type) {
            return this.types.contains(type);
        }

        @Override
        public Set<EntityType<?>> getTypes() {
            return this.types;
        }

        public SetMatch(Set<EntityType<?>> types) {
            this.types = types;
        }
    }

    private static class TagMatch
    extends EntityIngredient {
        private final TagKey<EntityType<?>> tag;
        private Set<EntityType<?>> types;

        public Loadable<TagMatch> loadable() {
            return TAG_MATCH;
        }

        @Override
        public boolean test(EntityType<?> type) {
            return type.m_204039_(this.tag);
        }

        @Override
        public Set<EntityType<?>> getTypes() {
            if (this.types == null) {
                this.types = RegistryHelper.getTagValueStream(BuiltInRegistries.f_256780_, this.tag).collect(Collectors.toUnmodifiableSet());
            }
            return this.types;
        }

        public TagMatch(TagKey<EntityType<?>> tag) {
            this.tag = tag;
        }
    }

    private static class Compound
    extends EntityIngredient {
        private final List<EntityIngredient> ingredients;
        private Set<EntityType<?>> allTypes;

        public Loadable<Compound> loadable() {
            return COMPOUND;
        }

        @Override
        public boolean test(EntityType<?> type) {
            for (EntityIngredient ingredient : this.ingredients) {
                if (!ingredient.test(type)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<EntityType<?>> getTypes() {
            if (this.allTypes == null) {
                this.allTypes = this.ingredients.stream().flatMap(ingredient -> ingredient.getTypes().stream()).collect(Collectors.toUnmodifiableSet());
            }
            return this.allTypes;
        }

        public Compound(List<EntityIngredient> ingredients) {
            this.ingredients = ingredients;
        }
    }

    public record EntityInput(EntityType<?> type) {
        public static List<EntityInput> wrap(Collection<EntityType<?>> types) {
            return types.stream().map(EntityInput::new).toList();
        }
    }
}

